/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.AbstractRealInterval;
import net.imglib2.roi.geom.real.Box;
import net.imglib2.roi.geom.real.WritableBox;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;

public abstract class AbstractWritableBox
extends AbstractRealInterval
implements WritableBox {
    public AbstractWritableBox(double[] min, double[] max) {
        super(min, max);
    }

    @Override
    public double sideLength(int d) {
        return Math.abs(this.max[d] - this.min[d]);
    }

    @Override
    public RealLocalizableRealPositionable center() {
        double[] center = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            center[d] = (this.max[d] + this.min[d]) / 2.0;
        }
        return new BoxCenter(center);
    }

    @Override
    public void setSideLength(int d, double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("Cannot have negative edge lengths ");
        }
        double center = (this.max[d] + this.min[d]) / 2.0;
        this.max[d] = center + length / 2.0;
        this.min[d] = center - length / 2.0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Box && Box.equals(this, (Box)obj);
    }

    public int hashCode() {
        return Box.hashCode(this);
    }

    private class BoxCenter
    extends AbstractRealMaskPoint {
        protected BoxCenter(double[] center) {
            super(center);
        }

        @Override
        public void updateBounds() {
            for (int d = 0; d < this.n; ++d) {
                double halfSideLength = AbstractWritableBox.this.sideLength(d) / 2.0;
                ((AbstractWritableBox)AbstractWritableBox.this).max[d] = this.position[d] + halfSideLength;
                ((AbstractWritableBox)AbstractWritableBox.this).min[d] = this.position[d] - halfSideLength;
            }
        }
    }
}

