/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.roi.util.iterationcode.IterationCodeBuilder;
import net.imglib2.view.Views;

public class LabelRegions<T>
extends AbstractEuclideanSpace
implements Iterable<LabelRegion<T>> {
    final RandomAccessibleInterval<LabelingType<T>> labeling;
    private final LabelingType<T> type;
    protected final ArrayList<FragmentProperties> indexToFragmentProperties;
    private final HashMap<T, LabelRegionProperties> labelToLabelRegionProperties;
    private final HashMap<T, LabelRegionProperties> allLabelToLabelRegionProperties;
    private final HashMap<T, LabelRegion<T>> labelToLabelRegion;
    private int expectedGeneration;

    public LabelRegions(RandomAccessibleInterval<LabelingType<T>> labeling) {
        super(labeling.numDimensions());
        this.labeling = labeling;
        this.type = (LabelingType)Views.iterable(labeling).firstElement();
        this.indexToFragmentProperties = new ArrayList();
        this.labelToLabelRegionProperties = new HashMap();
        this.allLabelToLabelRegionProperties = new HashMap();
        this.labelToLabelRegion = new HashMap();
        this.expectedGeneration = this.type.getGeneration() - 1;
    }

    public LabelRegion<T> getLabelRegion(T label) {
        this.update();
        LabelRegion<T> labelRegion = this.labelToLabelRegion.get(label);
        if (labelRegion == null) {
            labelRegion = new LabelRegion<T>(this, this.labelToLabelRegionProperties.get(label), label);
            this.labelToLabelRegion.put(label, labelRegion);
        }
        return labelRegion;
    }

    public Set<T> getExistingLabels() {
        this.update();
        return this.labelToLabelRegionProperties.keySet();
    }

    @Override
    public Iterator<LabelRegion<T>> iterator() {
        this.update();
        final Iterator<T> labelIterator = this.labelToLabelRegionProperties.keySet().iterator();
        return new Iterator<LabelRegion<T>>(){

            @Override
            public boolean hasNext() {
                return labelIterator.hasNext();
            }

            @Override
            public LabelRegion<T> next() {
                Object label = labelIterator.next();
                LabelRegion labelRegion = (LabelRegion)LabelRegions.this.labelToLabelRegion.get(label);
                if (labelRegion == null) {
                    labelRegion = new LabelRegion(LabelRegions.this, (LabelRegionProperties)((Object)LabelRegions.this.labelToLabelRegionProperties.get(label)), label);
                    LabelRegions.this.labelToLabelRegion.put(label, labelRegion);
                }
                return labelRegion;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update() {
        if (this.type.getGeneration() != this.expectedGeneration) {
            LabelRegions labelRegions = this;
            synchronized (labelRegions) {
                int generation = this.type.getGeneration();
                if (generation != this.expectedGeneration) {
                    for (LabelRegionProperties props : this.allLabelToLabelRegionProperties.values()) {
                        props.reset();
                    }
                    HashMap<T, LabelRegion<T>> oldLabelToLabelRegion = new HashMap<T, LabelRegion<T>>(this.labelToLabelRegion);
                    this.indexToFragmentProperties.clear();
                    this.labelToLabelRegionProperties.clear();
                    this.labelToLabelRegion.clear();
                    LabelingMapping<T> mapping = this.type.getMapping();
                    int numFragments = mapping.numSets();
                    for (int i = 0; i < numFragments; ++i) {
                        this.indexToFragmentProperties.add(new FragmentProperties(i, this.labeling));
                    }
                    Cursor c = Views.flatIterable(this.labeling).localizingCursor();
                    while (c.hasNext()) {
                        int index = ((LabelingType)c.next()).getIndex().getInteger();
                        if (index <= 0) continue;
                        this.indexToFragmentProperties.get(index).add((Localizable)c);
                    }
                    for (FragmentProperties fragmentProperties : this.indexToFragmentProperties) {
                        fragmentProperties.finish();
                    }
                    for (FragmentProperties fragmentProperties : this.indexToFragmentProperties) {
                        if (fragmentProperties.getSize() <= 0L) continue;
                        Set<T> fragLabels = mapping.labelsAtIndex(fragmentProperties.getIndex());
                        for (T label : fragLabels) {
                            LabelRegionProperties props = this.labelToLabelRegionProperties.get(label);
                            if (props == null) {
                                props = this.allLabelToLabelRegionProperties.get(label);
                                if (props == null) {
                                    props = new LabelRegionProperties(this);
                                    this.allLabelToLabelRegionProperties.put(label, props);
                                }
                                this.labelToLabelRegionProperties.put(label, props);
                            }
                            props.add(fragmentProperties);
                        }
                    }
                    for (Map.Entry entry : this.labelToLabelRegionProperties.entrySet()) {
                        Object label = entry.getKey();
                        LabelRegionProperties props = (LabelRegionProperties)((Object)entry.getValue());
                        props.finish();
                        LabelRegion<T> labelRegion = oldLabelToLabelRegion.get(label);
                        if (labelRegion == null) continue;
                        this.labelToLabelRegion.put(label, labelRegion);
                    }
                    oldLabelToLabelRegion.clear();
                    this.expectedGeneration = generation;
                    this.update();
                }
            }
        }
        return this.expectedGeneration;
    }

    static final class LabelRegionProperties
    extends AbstractEuclideanSpace {
        private long size;
        private final long[] sumPositions;
        private final double[] centerOfMass;
        private final long[] bbmin;
        private final long[] bbmax;
        private final ArrayList<TIntArrayList> itcodes;
        private final LabelRegions<?> labelRegions;

        LabelRegionProperties(LabelRegions<?> labelRegions) {
            super(labelRegions.numDimensions());
            this.labelRegions = labelRegions;
            this.sumPositions = new long[this.n];
            this.centerOfMass = new double[this.n];
            this.bbmin = new long[this.n];
            this.bbmax = new long[this.n];
            this.itcodes = new ArrayList();
            this.reset();
        }

        int update() {
            return ((LabelRegions)this.labelRegions).update();
        }

        void reset() {
            this.size = 0L;
            Arrays.fill(this.sumPositions, 0L);
            Arrays.fill(this.centerOfMass, 0.0);
            Arrays.fill(this.bbmin, Long.MAX_VALUE);
            Arrays.fill(this.bbmax, Long.MIN_VALUE);
            this.itcodes.clear();
        }

        void add(FragmentProperties frag) {
            this.size += frag.getSize();
            long[] fragSumPositions = frag.getSumPositions();
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.sumPositions[n] = this.sumPositions[n] + fragSumPositions[d];
            }
            long[] fragBBMin = frag.getBoundingBoxMin();
            long[] fragBBMax = frag.getBoundingBoxMax();
            for (int d = 0; d < this.n; ++d) {
                if (fragBBMin[d] < this.bbmin[d]) {
                    this.bbmin[d] = fragBBMin[d];
                }
                if (fragBBMax[d] <= this.bbmax[d]) continue;
                this.bbmax[d] = fragBBMax[d];
            }
            this.itcodes.add(frag.getItcode());
        }

        void finish() {
            if (this.size != 0L) {
                for (int d = 0; d < this.n; ++d) {
                    this.centerOfMass[d] = (double)this.sumPositions[d] / (double)this.size;
                }
            }
        }

        long getSize() {
            return this.size;
        }

        long[] getSumPositions() {
            return this.sumPositions;
        }

        double[] getCenterOfMass() {
            return this.centerOfMass;
        }

        long[] getBoundingBoxMin() {
            return this.bbmin;
        }

        long[] getBoundingBoxMax() {
            return this.bbmax;
        }

        ArrayList<TIntArrayList> getItcodes() {
            return this.itcodes;
        }
    }

    static final class FragmentProperties
    extends IterationCodeBuilder {
        private final int index;
        private final long[] sumPositions;

        public <T> FragmentProperties(int index, RandomAccessibleInterval<LabelingType<T>> labeling) {
            super(labeling.numDimensions(), labeling.min(0));
            this.index = index;
            this.sumPositions = new long[this.n];
        }

        public int getIndex() {
            return this.index;
        }

        public long[] getSumPositions() {
            return this.sumPositions;
        }

        @Override
        public void add(Localizable pos) {
            super.add(pos);
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.sumPositions[n] = this.sumPositions[n] + pos.getLongPosition(d);
            }
        }
    }
}

