/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.clojure;

import clojure.lang.Compiler;
import clojure.lang.LispReader;
import clojure.lang.Var;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.scijava.plugins.scripting.clojure.ClojureBindings;
import org.scijava.script.AbstractScriptEngine;

public class ClojureScriptEngine
extends AbstractScriptEngine {
    public ClojureScriptEngine() {
        this.engineScopeBindings = new ClojureBindings();
    }

    public Object eval(String script) throws ScriptException {
        try {
            return this.eval(new StringReader(script));
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Object eval(Reader reader) throws ScriptException {
        this.setup();
        try {
            Object form;
            Object filename = this.get("javax.script.filename");
            if (filename == null || filename instanceof Var.Unbound) {
                this.put("clojure.core.*file*", "/clojure-dynamic-script");
            } else {
                this.put("clojure.core.*file*", filename);
            }
            Thread thread = Thread.currentThread();
            Object finalResult = null;
            while (!thread.isInterrupted() && (form = LispReader.read((PushbackReader)new PushbackReader(reader), (boolean)false, (Object)((Object)this), (boolean)false)) != this) {
                finalResult = Compiler.eval((Object)form);
            }
            return finalResult;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    protected void setup() {
        Writer errorWriter;
        Writer writer;
        ScriptContext context = this.getContext();
        Reader reader = context.getReader();
        if (reader != null) {
            this.engineScopeBindings.put("clojure.core.*in*", (Object)reader);
        }
        if ((writer = context.getWriter()) != null) {
            this.engineScopeBindings.put("clojure.core.*out*", (Object)writer);
        }
        if ((errorWriter = context.getErrorWriter()) != null) {
            this.engineScopeBindings.put("clojure.core.*err*", (Object)errorWriter);
        }
    }
}

