/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.IOException;
import loci.common.IRandomAccess;

public abstract class AbstractNIOHandle
implements IRandomAccess {
    protected static final String EOF_ERROR_MSG = "Attempting to read beyond end of file.";

    @Override
    public boolean exists() throws IOException {
        return this.length() >= 0L;
    }

    protected void validateMode(String mode) {
        if (!mode.equals("r") && !mode.equals("rw")) {
            throw new IllegalArgumentException(String.format("%s mode not in supported modes ('r', 'rw')", mode));
        }
    }

    protected boolean validateLength(int writeLength) throws IOException {
        if (this.getFilePointer() + (long)writeLength > this.length()) {
            this.setLength(this.getFilePointer() + (long)writeLength);
            return false;
        }
        return true;
    }

    protected abstract void setLength(long var1) throws IOException;
}

