/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PreviewPane
extends JScrollPane {
    private static final long serialVersionUID = -854781598723857579L;
    private final JTextArea previewText = new JTextArea();

    public PreviewPane() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("FontChooser");
        this.previewText.setText(resourceBundle.getString("font.preview.text"));
        this.setPreviewTextBorder();
        this.setPreferredSize(new Dimension(200, 80));
        this.setViewportView(this.previewText);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setPreviewTextBorder();
    }

    private void setPreviewTextBorder() {
        if (this.previewText == null) {
            return;
        }
        this.previewText.setBorder(BorderFactory.createCompoundBorder(this.previewText.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    public void setPreviewFont(Font font) {
        this.previewText.setFont(font);
    }
}

