/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerMap;

public class WrappedInputTriggerMap
extends InputTriggerMap {
    private final InputTriggerMap inputTriggerMap;
    private InputTriggerMap parent;
    private int expectedParentModCount;

    public WrappedInputTriggerMap(InputTriggerMap inputTriggerMap) {
        this.inputTriggerMap = inputTriggerMap;
        this.parent = null;
        this.expectedParentModCount = 0;
    }

    @Override
    public void setParent(InputTriggerMap map) {
        this.parent = map;
        if (map != null) {
            this.expectedParentModCount = this.parent.modCount();
        }
    }

    @Override
    public InputTriggerMap getParent() {
        return this.parent;
    }

    @Override
    public synchronized void put(InputTrigger inputTrigger, String behaviourKey) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized Set<String> get(InputTrigger inputTrigger) {
        Set<Object> keys = null;
        keys = this.parent != null ? this.parent.get(inputTrigger) : new HashSet();
        keys.addAll(this.inputTriggerMap.get(inputTrigger));
        return keys;
    }

    @Override
    public synchronized void remove(InputTrigger inputTrigger, String behaviourKey) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized void removeAll(InputTrigger inputTrigger) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized Map<InputTrigger, Set<String>> getAllBindings() {
        Map<InputTrigger, Set<String>> allBindings = this.parent != null ? this.parent.getAllBindings() : new HashMap<InputTrigger, Set<String>>();
        for (Map.Entry<InputTrigger, Set<String>> entry : this.inputTriggerMap.getAllBindings().entrySet()) {
            InputTrigger inputTrigger = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Set behaviourKeys = allBindings.computeIfAbsent(inputTrigger, k -> new HashSet());
            behaviourKeys.addAll((Collection)entry.getValue());
        }
        return allBindings;
    }

    @Override
    public int modCount() {
        int m;
        if (this.parent != null && (m = this.parent.modCount()) != this.expectedParentModCount) {
            this.expectedParentModCount = m;
            this.inputTriggerMap.remove(null, null);
        }
        return this.inputTriggerMap.modCount();
    }
}

