/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;

public class TextureUnitStateState
extends NodeComponentState {
    private int texCoordGeneration;
    private int texture;
    private int textureAttributes;

    public TextureUnitStateState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            TextureUnitState attr = (TextureUnitState)this.node;
            this.texCoordGeneration = control.getSymbolTable().addReference(attr.getTexCoordGeneration());
            this.texture = control.getSymbolTable().addReference(attr.getTexture());
            this.textureAttributes = control.getSymbolTable().addReference(attr.getTextureAttributes());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.texCoordGeneration);
        out.writeInt(this.texture);
        out.writeInt(this.textureAttributes);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        TextureUnitState attr = (TextureUnitState)this.node;
        this.texCoordGeneration = in.readInt();
        this.texture = in.readInt();
        this.textureAttributes = in.readInt();
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.texCoordGeneration);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texture);
        this.control.getSymbolTable().incNodeComponentRefCount(this.textureAttributes);
    }

    @Override
    public void buildGraph() {
        TextureUnitState attr = (TextureUnitState)this.node;
        attr.setTexCoordGeneration((TexCoordGeneration)this.control.getSymbolTable().getJ3dNode(this.texCoordGeneration));
        attr.setTexture((Texture)this.control.getSymbolTable().getJ3dNode(this.texture));
        attr.setTextureAttributes((TextureAttributes)this.control.getSymbolTable().getJ3dNode(this.textureAttributes));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureUnitState();
    }
}

