/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.type.numeric.RealType;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.Warning;

public abstract class Algorithm<T extends RealType<T>> {
    protected String name;
    List<Warning> warnings = new ArrayList<Warning>();

    public Algorithm(String name) {
        this.name = name;
    }

    public abstract void execute(DataContainer<T> var1) throws MissingPreconditionException;

    public String getName() {
        return this.name;
    }

    public void processResults(ResultHandler<T> handler) {
        for (Warning w : this.warnings) {
            handler.handleWarning(w);
        }
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    protected void addWarning(String shortMsg, String longMsg) {
        this.warnings.add(new Warning(shortMsg, longMsg));
    }
}

