/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli.help;

import io.scif.cli.AbstractSCIFIOToolCommand;
import io.scif.cli.SCIFIOToolCommand;
import io.scif.cli.SCIFIOTools;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.scijava.plugin.Plugin;

@Plugin(type=SCIFIOToolCommand.class)
public class Help
extends AbstractSCIFIOToolCommand {
    @Argument(metaVar="command", index=0, usage="display help information for the given command")
    private String command;
    @Argument(index=1, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();

    @Override
    protected void run() throws CmdLineException {
        SCIFIOTools.run(this.command, "-h");
    }

    @Override
    protected String description() {
        return "command line tool for displaying help about a command.";
    }

    @Override
    protected String getName() {
        return "help";
    }

    @Override
    protected List<String> getExtraArguments() {
        return this.arguments;
    }

    @Override
    protected void validateParams() throws CmdLineException {
        if (this.command == null) {
            throw new CmdLineException(null, "Argument \"command\" is required");
        }
    }

    @Override
    public String commandName() {
        return "help";
    }
}

