/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.RectangleRegionOfInterest;
import org.scijava.Context;

public class PointOverlay
extends AbstractROIOverlay<RectangleRegionOfInterest> {
    private static final long serialVersionUID = 1L;
    private List<double[]> points = new ArrayList<double[]>();

    public PointOverlay() {
        super(new RectangleRegionOfInterest(new double[2], new double[2]));
    }

    public PointOverlay(Context context) {
        super(context, new RectangleRegionOfInterest(new double[2], new double[2]));
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    public PointOverlay(Context context, List<double[]> pts) {
        this(context);
        this.setPoints(pts);
    }

    public PointOverlay(Context context, double[] pt) {
        this(context, Arrays.asList(new double[][]{pt}));
    }

    public List<double[]> getPoints() {
        return this.points;
    }

    public void setPoints(List<double[]> pts) {
        this.points.clear();
        for (double[] pt : pts) {
            this.points.add((double[])pt.clone());
        }
        this.calcRegion();
    }

    public void setPoint(int i, double[] pt) {
        double[] p = this.points.get(i);
        p[0] = pt[0];
        p[1] = pt[1];
        this.calcRegion();
    }

    public double[] getPoint(int i) {
        return this.points.get(i);
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.points.size());
        out.writeInt(this.numDimensions());
        for (int p = 0; p < this.points.size(); ++p) {
            double[] pt = this.points.get(p);
            for (int i = 0; i < this.numDimensions(); ++i) {
                out.writeDouble(pt[i]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.points.clear();
        int numP = in.readInt();
        int nDimensions = in.readInt();
        double[] position = new double[nDimensions];
        for (int p = 0; p < numP; ++p) {
            for (int j = 0; j < nDimensions; ++j) {
                position[j] = in.readDouble();
            }
            this.points.add((double[])position.clone());
        }
        this.calcRegion();
    }

    @Override
    public void move(double[] deltas) {
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).move(deltas);
        for (int p = 0; p < this.points.size(); ++p) {
            double[] pt = this.points.get(p);
            for (int i = 0; i < deltas.length; ++i) {
                int n = i;
                pt[n] = pt[n] + deltas[i];
            }
        }
    }

    private void calcRegion() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (double[] pt : this.points) {
            if (pt[0] < minX) {
                minX = pt[0];
            }
            if (pt[0] > maxX) {
                maxX = pt[0];
            }
            if (pt[1] < minY) {
                minY = pt[1];
            }
            if (!(pt[1] > maxY)) continue;
            maxY = pt[1];
        }
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setOrigin(minX, 0);
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setOrigin(minY, 1);
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setExtent(maxX - minX, 0);
        ((RectangleRegionOfInterest)this.getRegionOfInterest()).setExtent(maxY - minY, 1);
    }
}

