/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType32BitSignedFloat
extends AbstractContextual
implements DataType<FloatType> {
    private final FloatType type = new FloatType();

    @Override
    public FloatType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "32-bit float";
    }

    @Override
    public String longName() {
        return "32-bit signed float";
    }

    @Override
    public String description() {
        return "A floating data type ranging from -3.4028235E38 to 3.4028235E38";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(FloatType dest) {
        dest.set(-3.4028235E38f);
    }

    @Override
    public void upperBound(FloatType dest) {
        dest.set(Float.MAX_VALUE);
    }

    @Override
    public int bitCount() {
        return 32;
    }

    @Override
    public FloatType createVariable() {
        return new FloatType();
    }

    @Override
    public void cast(FloatType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, FloatType dest) {
        dest.set(val.getReal().floatValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(FloatType val) {
        return val.get();
    }

    @Override
    public long asLong(FloatType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(FloatType val, double v) {
        val.setReal(v);
    }

    @Override
    public void setLong(FloatType val, long v) {
        val.setReal((float)v);
    }
}

