/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.TranslationGet;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public abstract class AbstractTranslation
implements TranslationGet {
    protected final double[] t;
    protected final RealPoint[] ds;

    protected AbstractTranslation(double[] t, RealPoint[] ds) {
        assert (t.length == ds.length) : "Input dimensions do not match.";
        this.t = t;
        this.ds = ds;
    }

    public AbstractTranslation(int n) {
        this.t = new double[n];
        this.ds = new RealPoint[n];
        for (int d = 0; d < n; ++d) {
            this.ds[d] = new RealPoint(n);
            this.ds[d].setPosition(1, d);
        }
    }

    public AbstractTranslation(double ... t) {
        this(t.length);
        this.set(t);
    }

    public abstract void set(double ... var1);

    public abstract void set(double var1, int var3);

    public int numDimensions() {
        return this.t.length;
    }

    @Override
    public int numSourceDimensions() {
        return this.t.length;
    }

    @Override
    public int numTargetDimensions() {
        return this.t.length;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.t.length && target.length >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            target[d] = source[d] + this.t[d];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.t.length && target.length >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            target[d] = (float)((double)source[d] + this.t[d]);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.t.length && target.numDimensions() >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            target.setPosition(source.getDoublePosition(d) + this.t[d], d);
        }
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.t.length && target.length >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            source[d] = target[d] - this.t[d];
        }
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.t.length && target.length >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            source[d] = (float)((double)target[d] - this.t[d]);
        }
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.t.length && target.numDimensions() >= this.t.length) : "Input dimensions too small.";
        for (int d = 0; d < this.t.length; ++d) {
            source.setPosition(target.getDoublePosition(d) - this.t[d], d);
        }
    }

    @Override
    public abstract AbstractTranslation copy();

    @Override
    public double get(int row, int column) {
        return column == this.t.length ? this.t[row] : (row == column ? 1.0 : 0.0);
    }

    @Override
    public double[] getRowPackedCopy() {
        int stepT = this.t.length + 1;
        int stepI = stepT + 1;
        double[] matrix = new double[this.t.length * this.t.length + this.t.length];
        for (int d = 0; d < this.t.length; ++d) {
            matrix[d * stepI] = 1.0;
            matrix[d * stepT + this.t.length] = this.t[d];
        }
        return matrix;
    }

    @Override
    public RealLocalizable d(int d) {
        assert (d >= 0 && d < this.numDimensions()) : "Dimension index out of bounds.";
        return this.ds[d];
    }

    @Override
    public double getScale(int d) {
        return 0.0;
    }

    @Override
    public double[] getScaleCopy() {
        return new double[this.t.length];
    }

    @Override
    public double getTranslation(int d) {
        assert (d >= 0 && d < this.numDimensions()) : "Dimension index out of bounds.";
        return this.t[d];
    }

    @Override
    public double[] getTranslationCopy() {
        return (double[])this.t.clone();
    }

    @Override
    public abstract AbstractTranslation inverse();

    @Override
    public RealInterval boundingInterval(RealInterval interval, IntervalSamplingMethod samplingMethdod) {
        assert (interval.numDimensions() >= this.t.length) : "Interval does not have enough dimensions.";
        double[] min = interval.minAsDoubleArray();
        double[] max = interval.maxAsDoubleArray();
        for (int d = 0; d < this.t.length; ++d) {
            int n = d;
            min[n] = min[n] + this.t[d];
            int n2 = d;
            max[n2] = max[n2] + this.t[d];
        }
        return new FinalRealInterval(min, max, false);
    }
}

