/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.util.ByteCodeAnalyzer;
import net.imagej.updater.util.Class2JarFilesMap;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.util.FileUtils;

public class DependencyAnalyzer {
    private final Class2JarFilesMap map;

    public DependencyAnalyzer(File imagejRoot) {
        this.map = new Class2JarFilesMap(imagejRoot);
    }

    public Iterable<String> getDependencies(File imagejRoot, String path) throws IOException {
        return this.getDependencies(imagejRoot, new FileObject(null, path, 0L, "", 20000000000000L, FileObject.Status.INSTALLED));
    }

    public Iterable<String> getDependencies(File imagejRoot, FileObject fileObject) throws IOException {
        String path = fileObject.getFilename();
        if (!path.endsWith(".jar")) {
            return null;
        }
        File file = new File(imagejRoot, path);
        if (!file.exists()) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> handled = new HashSet<String>();
        JarFile jar = new JarFile(file);
        block2: for (JarEntry entry : Collections.list(jar.entries())) {
            ByteCodeAnalyzer analyzer;
            if (!entry.getName().endsWith(".class") || entry.getName().endsWith("module-info.class")) continue;
            InputStream input = jar.getInputStream(entry);
            byte[] code = UpdaterUtil.readStreamAsBytes(input);
            try {
                analyzer = new ByteCodeAnalyzer(code, ByteCodeAnalyzer.Mode.INTERFACES);
            }
            catch (RuntimeException exc) {
                String fqcn = entry.getName();
                String jarPath = jar.getName();
                throw new RuntimeException("Could not analyze class '" + fqcn + "' from JAR '" + jarPath + "'", exc);
            }
            HashSet<String> allClassNames = new HashSet<String>();
            for (String name : analyzer) {
                this.addClassAndInterfaces(allClassNames, handled, name);
            }
            for (String name : allClassNames) {
                UpdaterUserInterface.get().debug("Considering name from analyzer: " + name);
                List jars = (List)this.map.get(name);
                if (jars == null) continue;
                LinkedHashSet<String> orderedJARs = new LinkedHashSet<String>();
                for (Dependency d : fileObject.getDependencies()) {
                    if (!new File(imagejRoot, d.filename).exists()) continue;
                    orderedJARs.add(d.filename);
                }
                orderedJARs.addAll(jars);
                ArrayList<String> dependencies = new ArrayList<String>();
                for (String dependency : orderedJARs) {
                    if (DependencyAnalyzer.exclude(path, dependency)) continue;
                    if (fileObject.hasDependency(dependency)) continue block2;
                    dependencies.add(dependency);
                }
                if (dependencies.size() > 1) {
                    UpdaterUserInterface.get().log("Warning: class " + name + ", referenced in " + path + ", is in more than one jar:");
                    for (String j : dependencies) {
                        UpdaterUserInterface.get().log("  " + j);
                    }
                    UpdaterUserInterface.get().log("... adding all as dependency.");
                }
                for (String j : dependencies) {
                    result.add(j);
                    UpdaterUserInterface.get().debug("... adding dep " + j + " for " + path + " because of class " + name);
                }
            }
        }
        jar.close();
        return result;
    }

    protected void addClassAndInterfaces(Set<String> allClassNames, Set<String> handled, String className) {
        if (className == null || className.startsWith("[") || handled.contains(className)) {
            return;
        }
        handled.add(className);
        String resourceName = "/" + className.replace('.', '/') + ".class";
        if (ClassLoader.getSystemClassLoader().getResource(resourceName) != null) {
            return;
        }
        allClassNames.add(className);
        try {
            byte[] buffer = UpdaterUtil.readStreamAsBytes(this.getClass().getResourceAsStream(resourceName));
            ByteCodeAnalyzer analyzer = new ByteCodeAnalyzer(buffer, ByteCodeAnalyzer.Mode.INTERFACES);
            this.addClassAndInterfaces(allClassNames, handled, analyzer.getSuperclass());
            for (String iface : analyzer.getInterfaces()) {
                this.addClassAndInterfaces(allClassNames, handled, iface);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean containsDebugInfo(String filename) throws IOException {
        if (!filename.endsWith(".jar") || !new File(filename).exists()) {
            return false;
        }
        JarFile jar = new JarFile(filename);
        for (JarEntry file : Collections.list(jar.entries())) {
            InputStream input;
            byte[] code;
            ByteCodeAnalyzer analyzer;
            if (!file.getName().endsWith(".class") || !(analyzer = new ByteCodeAnalyzer(code = UpdaterUtil.readStreamAsBytes(input = jar.getInputStream(file)), ByteCodeAnalyzer.Mode.METHODS)).containsDebugInfo()) continue;
            return true;
        }
        jar.close();
        return false;
    }

    private static boolean equals(String unversionedBaseName, String other) {
        if (other.equals(unversionedBaseName + ".jar")) {
            return true;
        }
        return FileUtils.stripFilenameVersion((String)other).equals(unversionedBaseName + ".jar");
    }

    protected static boolean exclude(String jarPath, String dependency) {
        return jarPath.equals(dependency) || DependencyAnalyzer.equals("jars/javac", dependency) || DependencyAnalyzer.equals("jars/j3d-core", dependency) || DependencyAnalyzer.equals("jars/j3d-core-utils", dependency) || DependencyAnalyzer.equals("jars/vecmath", dependency) || DependencyAnalyzer.equals("jars/slf4j-api", jarPath) || DependencyAnalyzer.equals("jars/jython", jarPath) && DependencyAnalyzer.equals("jars/jruby-complete", dependency) || DependencyAnalyzer.equals("jars/jruby-complete", jarPath) && DependencyAnalyzer.equals("jars/jython", dependency) || DependencyAnalyzer.equals("jars/logkit", jarPath) && DependencyAnalyzer.equals("jars/avalon-framework", dependency) || DependencyAnalyzer.equals("jars/bsh", jarPath) && DependencyAnalyzer.equals("jars/testng", dependency) || DependencyAnalyzer.equals("jars/testng", jarPath) && DependencyAnalyzer.equals("jars/guice", dependency) || (DependencyAnalyzer.equals("jars/MMCoreJ", jarPath) || DependencyAnalyzer.equals("plugins/MMCoreJ", jarPath)) && DependencyAnalyzer.equals("plugins/MMJ_", dependency);
    }
}

