/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.analyzer;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ImageJService;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import sc.fiji.filamentdetector.analyzer.Analyzer;
import sc.fiji.filamentdetector.analyzer.LengthOverTimeAnalyzer;
import sc.fiji.filamentdetector.analyzer.NaiveNucleationAnalyzer;
import sc.fiji.filamentdetector.analyzer.TipFitterAnalyzer;

@Plugin(type=Service.class)
public class AnalyzerService
extends AbstractService
implements ImageJService {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> detectors = new ArrayList<Analyzer>();
        for (PluginInfo pluginInfo : this.pluginService.getPluginsOfType(Analyzer.class)) {
            try {
                Analyzer plugin = (Analyzer)pluginInfo.createInstance();
                plugin.setContext(this.context);
                detectors.add(plugin);
            }
            catch (InstantiableException e) {
                this.log.error((Object)("Can't load the following Analyzer : " + pluginInfo.getName()));
                this.log.error((Object)e.getMessage());
            }
        }
        return detectors;
    }

    public LengthOverTimeAnalyzer getLengthOverTimeAnalyzer() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(LengthOverTimeAnalyzer.class);
        try {
            LengthOverTimeAnalyzer plugin = (LengthOverTimeAnalyzer)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Analyzer : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }

    public TipFitterAnalyzer getTipFitterAnalyzer() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(TipFitterAnalyzer.class);
        try {
            TipFitterAnalyzer plugin = (TipFitterAnalyzer)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Analyzer : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }

    public NaiveNucleationAnalyzer getNaiveNucleationAnalyzer() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(NaiveNucleationAnalyzer.class);
        try {
            NaiveNucleationAnalyzer plugin = (NaiveNucleationAnalyzer)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Analyzer : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }
}

