/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.analyzer;

import java.util.HashMap;
import org.scijava.plugin.Plugin;
import sc.fiji.filamentdetector.analyzer.AbstractAnalyzer;
import sc.fiji.filamentdetector.analyzer.Analyzer;
import sc.fiji.filamentdetector.analyzer.tipfitter.FilamentTipFitter;

@Plugin(type=Analyzer.class, priority=100.0)
public class TipFitterAnalyzer
extends AbstractAnalyzer {
    public static String NAME = "Tip Fitter";
    public static String DESCRIPTION = "Use tracked filaments as seeds to fit in 1D tip of filaments from both side. (this analyzer is in development)";
    private FilamentTipFitter fitter;

    public TipFitterAnalyzer() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    @Override
    public String getAnalyzerInfo() {
        String out = "";
        out = out + "Name : " + this.name + "\n";
        out = out + "polynomDegree : " + this.getFitter().getPolynomDegree() + "\n";
        out = out + "relativePositionFromEnd : " + this.getFitter().getRelativePositionFromEnd() + "\n";
        out = out + "lineFitLength : " + this.getFitter().getLineFitLength() + "\n";
        out = out + "channelIndex : " + this.getFitter().getChannelIndex() + "\n";
        out = out + "lineWidth : " + this.getFitter().getLineWidth() + "\n";
        out = out + "\n";
        return out;
    }

    @Override
    public void analyze() {
        this.getFitter().setSeeds(this.filamentWorkflow.getTrackedFilaments());
        this.getFitter().setImageDisplay(this.filamentWorkflow.getImageDisplay());
        this.getFitter().fit();
        this.results = new HashMap();
        this.results.put("side1Filaments", this.getFitter().getSide1Filaments());
        this.results.put("side2Filaments", this.getFitter().getSide2Filaments());
        this.resultMessage = "Tip Fitting done.\n";
        this.resultMessage = this.resultMessage + (this.getFitter().getSide1Filaments().size() + this.getFitter().getSide2Filaments().size());
        this.resultMessage = this.resultMessage + " filaments have been detected.";
    }

    public FilamentTipFitter getFitter() {
        if (this.fitter == null) {
            this.fitter = new FilamentTipFitter(this.filamentWorkflow.getContext());
        }
        return this.fitter;
    }
}

