/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.analyzer.Analyzer;
import sc.fiji.filamentdetector.analyzer.AnalyzerService;
import sc.fiji.filamentdetector.analyzer.LengthOverTimeAnalyzer;
import sc.fiji.filamentdetector.analyzer.TipFitterAnalyzer;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.gui.controller.analyzer.AnalyzerController;
import sc.fiji.filamentdetector.gui.controller.analyzer.LengthOverTimeAnalyzerController;
import sc.fiji.filamentdetector.gui.controller.analyzer.TipFitterAnalyzerController;

public class AnalyzeController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/AnalyzerView.fxml";
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private AnalyzerService analyzerService;
    @FXML
    private Label nFilamentsField;
    @FXML
    private Label nTrackedFilamentsField;
    @FXML
    private ComboBox<Analyzer> analyzerCombobox;
    @FXML
    private Label analyzerDescription;
    @FXML
    private TitledPane analyzerPane;
    @FXML
    private Button analyzeButton;
    private Thread analyzerThread;
    private Task<Integer> analyzerTask;
    private FilamentWorkflow filamentWorkflow;
    private List<Analyzer> analyzers;
    private Map<Analyzer, AnalyzerController> analyzerControllers;

    public AnalyzeController(Context context, FilamentWorkflow filamentWorkflow) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentWorkflow = filamentWorkflow;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.setNoAnalyzer();
        this.analyzerCombobox.setCellFactory((Callback)new Callback<ListView<Analyzer>, ListCell<Analyzer>>(){

            public ListCell<Analyzer> call(ListView<Analyzer> p) {
                return new ListCell<Analyzer>(){

                    protected void updateItem(Analyzer t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
        this.analyzerCombobox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.setAnalyzer((Analyzer)newValue);
            } else {
                this.setNoAnalyzer();
            }
        });
        this.analyzers = new ArrayList<Analyzer>();
        this.analyzerControllers = new HashMap<Analyzer, AnalyzerController>();
        LengthOverTimeAnalyzer lengthOverTimeAnalyzer = this.analyzerService.getLengthOverTimeAnalyzer();
        lengthOverTimeAnalyzer.setFilamentWorkflow(this.filamentWorkflow);
        LengthOverTimeAnalyzerController lengthOverTimeAnalyzerController = new LengthOverTimeAnalyzerController(this.context, lengthOverTimeAnalyzer);
        this.analyzers.add(lengthOverTimeAnalyzer);
        this.analyzerControllers.put(lengthOverTimeAnalyzer, lengthOverTimeAnalyzerController);
        TipFitterAnalyzer tipFitterAnalyzer = this.analyzerService.getTipFitterAnalyzer();
        tipFitterAnalyzer.setFilamentWorkflow(this.filamentWorkflow);
        TipFitterAnalyzerController tipFitterAnalyzerController = new TipFitterAnalyzerController(this.context, tipFitterAnalyzer);
        this.analyzers.add(tipFitterAnalyzer);
        this.analyzerControllers.put(tipFitterAnalyzer, tipFitterAnalyzerController);
        this.analyzerCombobox.setItems(FXCollections.observableList(this.analyzers));
        this.analyzerCombobox.getSelectionModel().clearSelection();
    }

    public void initPane() {
        if (this.filamentWorkflow.getTrackedFilaments() == null && this.filamentWorkflow.getFilaments() == null) {
            this.status.showStatus("No filaments detected. Please use the \\\"Detect Filaments\\\" panel and \"Track Filaments\" panel first.");
            this.getPane().setDisable(true);
            this.nTrackedFilamentsField.setText("");
            this.nFilamentsField.setText("");
        } else {
            this.getPane().setDisable(false);
            if (this.filamentWorkflow.getTrackedFilaments() != null) {
                this.nTrackedFilamentsField.setText(Integer.toString(this.filamentWorkflow.getTrackedFilaments().size()));
            }
            if (this.filamentWorkflow.getFilaments() != null) {
                this.nFilamentsField.setText(Integer.toString(this.filamentWorkflow.getFilaments().size()));
            }
        }
    }

    private void setNoAnalyzer() {
        Label noAnalyzerPane = new Label("No analyzer selected.");
        this.analyzerPane.setContent((Node)noAnalyzerPane);
        this.analyzeButton.setDisable(true);
    }

    private void setAnalyzer(Analyzer analyzer) {
        this.analyzerDescription.setText(analyzer.getDescription());
        AnalyzerController controller = this.analyzerControllers.get(analyzer);
        Pane pane = controller.loadPane();
        this.analyzerPane.setContent((Node)pane);
        this.analyzeButton.setDisable(false);
    }

    @FXML
    void analyze(ActionEvent event) {
        if (this.analyzerTask != null) {
            this.analyzerTask.cancel();
        }
        if (this.analyzerThread != null) {
            this.analyzerThread.stop();
        }
        this.analyzerTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                AnalyzeController.this.analyzerCombobox.setDisable(true);
                Analyzer analyzer = (Analyzer)AnalyzeController.this.analyzerCombobox.getSelectionModel().getSelectedItem();
                AnalyzeController.this.status.showStatus("Run analysis : ");
                AnalyzeController.this.status.showStatus(analyzer.getAnalyzerInfo());
                analyzer.analyze();
                return 0;
            }

            protected void succeeded() {
                super.succeeded();
                Analyzer analyzer = (Analyzer)AnalyzeController.this.analyzerCombobox.getSelectionModel().getSelectedItem();
                AnalyzeController.this.status.showStatus("Analysis Results are : ");
                AnalyzeController.this.status.showStatus(analyzer.getResultMessage());
                AnalyzeController.this.analyzerCombobox.setDisable(false);
                ((AnalyzerController)AnalyzeController.this.analyzerControllers.get(analyzer)).runPostAnalysisAction();
            }

            protected void cancelled() {
                super.cancelled();
                AnalyzeController.this.analyzerCombobox.setDisable(false);
            }

            protected void failed() {
                super.failed();
                AnalyzeController.this.analyzerCombobox.setDisable(false);
                AnalyzeController.this.status.showStatus("Something failed during analysis : ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                AnalyzeController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
            }
        };
        this.analyzerThread = new Thread((Runnable)this.analyzerTask);
        this.analyzerThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        this.analyzerThread.setDaemon(true);
        this.analyzerThread.start();
    }
}

