/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.analyzer;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.analyzer.NaiveNucleationAnalyzer;
import sc.fiji.filamentdetector.gui.controller.analyzer.AbstractAnalyzerController;
import sc.fiji.filamentdetector.gui.controller.analyzer.AnalyzerController;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;

public class NaiveNucleationAnalyzerController
extends AbstractAnalyzerController
implements AnalyzerController {
    private static String FXML_VIEW_FILE = "/sc/fiji/filamentdetector/gui/view/analyzer/NaiveNucleationAnalyzerView.fxml";
    @Parameter
    private StatusService status;
    @Parameter
    private LogService log;
    @Parameter
    private FilamentOverlayService overlay;
    @FXML
    private TextField channelIndexField;
    @FXML
    private Slider intensityThresholdSlider;
    @FXML
    private TextField intensityThresholdField;
    @FXML
    private Slider maxFrameSlider;
    @FXML
    private TextField maxFrameField;
    @FXML
    private Slider lineLengthSlider;
    @FXML
    private TextField lineLengthField;
    @FXML
    private Slider lineThicknessSlider;
    @FXML
    private TextField lineThicknessField;
    @FXML
    private Slider pixelSpacingSlider;
    @FXML
    private TextField pixelSpacingField;
    @FXML
    private TextField resultMessageField;
    @FXML
    private CheckBox colorizedCheckbox;
    private SliderLabelSynchronizer intensityThresholdSync;
    private SliderLabelSynchronizer maxFrameSync;
    private SliderLabelSynchronizer lineLengthSync;
    private SliderLabelSynchronizer lineThicknessSync;
    private SliderLabelSynchronizer pixelSpacingSync;
    private NaiveNucleationAnalyzer analyzer;

    public NaiveNucleationAnalyzerController(Context context, NaiveNucleationAnalyzer analyzer) {
        super(context);
        this.setFXMLPath(FXML_VIEW_FILE);
        this.analyzer = analyzer;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.analyzer.guessIntensityThresholdFromImage();
        this.intensityThresholdSync = new SliderLabelSynchronizer(this.intensityThresholdSlider, this.intensityThresholdField);
        this.intensityThresholdSync.setValue(this.analyzer.getIntensityThreshold());
        this.maxFrameSync = new SliderLabelSynchronizer(this.maxFrameSlider, this.maxFrameField);
        this.maxFrameSync.setValue(this.analyzer.getMaxFrame());
        this.lineLengthSync = new SliderLabelSynchronizer(this.lineLengthSlider, this.lineLengthField);
        this.lineLengthSync.setValue(this.analyzer.getLineLength());
        this.lineThicknessSync = new SliderLabelSynchronizer(this.lineThicknessSlider, this.lineThicknessField);
        this.lineThicknessSync.setValue(this.analyzer.getLineThickness());
        this.pixelSpacingSync = new SliderLabelSynchronizer(this.pixelSpacingSlider, this.pixelSpacingField);
        this.pixelSpacingSync.setValue(this.analyzer.getPixelSpacing());
        this.channelIndexField.setText(Integer.toString(this.analyzer.getChannelIndex()));
        this.colorizedCheckbox.setSelected(this.analyzer.isColorizedNucleatedSeeds());
        this.resultMessageField.setEditable(false);
        this.resultMessageField.setStyle("-fx-background-color:transparent; -fx-background-insets: 0px;");
    }

    @FXML
    void updateParameters(Event event) {
        if (this.intensityThresholdSync.isEvent(event)) {
            this.intensityThresholdSync.update(event);
            this.analyzer.setIntensityThreshold(this.intensityThresholdSync.getValue());
        } else if (this.maxFrameSync.isEvent(event)) {
            this.maxFrameSync.update(event);
            this.analyzer.setMaxFrame((int)this.maxFrameSync.getValue());
        } else if (this.lineLengthSync.isEvent(event)) {
            this.lineLengthSync.update(event);
            this.analyzer.setLineLength(this.lineLengthSync.getValue());
        } else if (this.lineThicknessSync.isEvent(event)) {
            this.lineThicknessSync.update(event);
            this.analyzer.setLineThickness(this.lineThicknessSync.getValue());
        } else if (this.pixelSpacingSync.isEvent(event)) {
            this.pixelSpacingSync.update(event);
            this.analyzer.setPixelSpacing(this.pixelSpacingSync.getValue());
        } else if (event.getSource().equals(this.channelIndexField)) {
            this.analyzer.setChannelIndex(Integer.parseInt(this.channelIndexField.getText()));
        } else if (event.getSource().equals(this.colorizedCheckbox)) {
            this.analyzer.setColorizedNucleatedSeeds(this.colorizedCheckbox.isSelected());
        }
    }

    @Override
    public void runPostAnalysisAction() {
        this.status.showStatus(this.analyzer.getResults().toString());
        this.resultMessageField.setText(this.analyzer.getResults().toString());
        this.overlay.refresh();
    }
}

