/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.gui.TextRoi;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mpicbg.models.CoordinateTransform;

public class DLabel
extends Displayable
implements VectorData {
    public static final int TEXT = 0;
    public static final int ARROW = 1;
    public static final int DOT = 2;
    private int type;
    private Font font;
    private JFrame editor = null;

    public DLabel(Project project, String text, double x, double y) {
        super(project, text, x, y);
        this.type = 0;
        this.width = 1.0f;
        this.height = 1.0f;
        this.font = new Font(TextRoi.getFont(), TextRoi.getStyle(), TextRoi.getSize());
        this.addToDatabase();
    }

    public DLabel(Project project, long id, String text, float width, float height, int type, String font_name, int font_style, int font_size, boolean locked, AffineTransform at) {
        super(project, id, text, locked, at, width, height);
        this.type = 0;
        this.font = new Font(font_name, font_style, font_size);
    }

    public int getType() {
        return this.type;
    }

    public DLabel(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        int font_size = 12;
        int font_style = 0;
        String font_family = "Courier";
        String data = ht.get("style");
        if (null != data) {
            String[] s1 = data.split(";");
            for (int i = 0; i < s1.length; ++i) {
                String[] s2 = s1[i].split(":");
                if (s2[0].equals("font-size")) {
                    font_size = Integer.parseInt(s2[1].trim());
                    continue;
                }
                if (s2[0].equals("font-style")) {
                    font_style = Integer.parseInt(s2[1].trim());
                    continue;
                }
                if (!s2[0].equals("font-family")) continue;
                font_family = s2[1].trim();
            }
        }
        this.font = new Font(font_family, font_style, font_size);
    }

    public Font getFont() {
        if (null == this.font) {
            this.reload();
        }
        return this.font;
    }

    public void flush() {
        this.title = null;
        this.font = null;
    }

    @Override
    public void setTitle(String title) {
        this.setText(title, true);
    }

    public void setText(String title, boolean update) {
        super.setTitle(title);
        if (null == title || 0 == title.length()) {
            return;
        }
        String text = this.getShortTitle();
        Dimension dim = Utils.getDimensions(text, this.font);
        this.width = dim.width;
        this.height = dim.height;
        Display.updateTransform(this);
        this.updateInDatabase("dimensions");
        this.updateBucket();
    }

    private void reload() {
        Object[] ob = this.project.getLoader().fetchLabel(this);
        if (null == ob) {
            return;
        }
        this.title = (String)ob[0];
        this.font = new Font((String)ob[1], (int)((Integer)ob[2]), (Integer)ob[3]);
    }

    @Override
    public String getShortTitle() {
        if (null == this.title) {
            this.reload();
        }
        if (null == this.title) {
            return "";
        }
        return this.title;
    }

    @Override
    public String toString() {
        if (null == this.title || 0 == this.title.length()) {
            return "<empty label> #" + this.id;
        }
        return this.getShortTitle() + " #" + this.id;
    }

    public void setType(int type) {
        if (type < 0 || type > 2) {
            return;
        }
        this.type = type;
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Composite original_composite = null;
        if (this.alpha != 1.0f) {
            original_composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        AffineTransform atg = g.getTransform();
        AffineTransform atp = (AffineTransform)atg.clone();
        atp.concatenate(this.at);
        g.setTransform(atp);
        if (active) {
            if (null == original_composite) {
                original_composite = g.getComposite();
            }
            g.setComposite(AlphaComposite.getInstance(3, 0.67f));
            g.setColor(new Color(255 - this.color.getRed(), 255 - this.color.getGreen(), 255 - this.color.getBlue()).brighter());
            g.fillRect(0, -((int)this.height), (int)this.width, (int)this.height);
            g.setComposite(original_composite);
        }
        g.setColor(this.color);
        switch (this.type) {
            case 0: {
                g.setFont(this.font);
                g.drawString(this.getShortTitle(), 0, 0);
            }
        }
        g.setTransform(atg);
        if (null != original_composite) {
            g.setComposite(original_composite);
        }
    }

    @Override
    public Rectangle getBoundingBox(Rectangle r) {
        if (null == r) {
            r = new Rectangle();
        }
        if (this.at.getType() == 1) {
            r.x = (int)this.at.getTranslateX();
            r.y = (int)(this.at.getTranslateY() - (double)this.height);
            r.width = (int)this.width;
            r.height = (int)this.height;
        } else {
            double[] d1 = new double[]{0.0, 0.0, this.width, 0.0, this.width, -this.height, 0.0, -this.height};
            double[] d2 = new double[8];
            this.at.transform(d1, 0, d2, 0, 4);
            double min_x = Double.MAX_VALUE;
            double min_y = Double.MAX_VALUE;
            double max_x = -min_x;
            double max_y = -min_y;
            for (int i = 0; i < d2.length; i += 2) {
                if (d2[i] < min_x) {
                    min_x = d2[i];
                }
                if (d2[i] > max_x) {
                    max_x = d2[i];
                }
                if (d2[i + 1] < min_y) {
                    min_y = d2[i + 1];
                }
                if (!(d2[i + 1] > max_y)) continue;
                max_y = d2[i + 1];
            }
            r.x = (int)min_x;
            r.y = (int)min_y;
            r.width = (int)(max_x - min_x);
            r.height = (int)(max_y - min_y);
        }
        return r;
    }

    @Override
    public Polygon getPerimeter() {
        if (this.at.isIdentity() || this.at.getType() == 1) {
            Rectangle r = this.getBoundingBox();
            return new Polygon(new int[]{r.x, r.x + r.width, r.x + r.width, r.x}, new int[]{r.y, r.y, r.y + r.height, r.y + r.height}, 4);
        }
        double[] po1 = new double[]{0.0, 0.0, this.width, 0.0, this.width, -this.height, 0.0, -this.height};
        double[] po2 = new double[8];
        this.at.transform(po1, 0, po2, 0, 4);
        return new Polygon(new int[]{(int)po2[0], (int)po2[2], (int)po2[4], (int)po2[6]}, new int[]{(int)po2[1], (int)po2[3], (int)po2[5], (int)po2[7]}, 4);
    }

    @Override
    public Polygon getPerimeter(int w, int n, int e, int s) {
        if (this.at.isIdentity() || this.at.getType() == 1) {
            Rectangle r = this.getBoundingBox();
            return new Polygon(new int[]{r.x - w, r.x + r.width + w + e, r.x + r.width + w + e, r.x - w}, new int[]{r.y - n, r.y - n, r.y + r.height + n + s, r.y + r.height + n + s}, 4);
        }
        double[] po1 = new double[]{-w, -n, this.width + (float)w + (float)e, -n, this.width + (float)w + (float)e, -this.height + (float)n + (float)s, -w, -this.height + (float)n + (float)s};
        double[] po2 = new double[8];
        this.at.transform(po1, 0, po2, 0, 4);
        return new Polygon(new int[]{(int)po2[0], (int)po2[2], (int)po2[4], (int)po2[6]}, new int[]{(int)po2[1], (int)po2[3], (int)po2[5], (int)po2[7]}, 4);
    }

    @Override
    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        Display.repaint(layer, this);
    }

    @Override
    public boolean isDeletable() {
        return null == this.title || "" == this.title;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        super.keyPressed(ke);
    }

    public void edit() {
        if (null == this.editor) {
            this.editor = new Editor(this);
        } else {
            this.editor.toFront();
        }
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        sb_body.append(indent).append("<t2_label\n");
        String in = indent + "\t";
        super.exportXML(sb_body, in, options);
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("style=\"font-size:").append(this.font.getSize()).append(";font-style:").append(this.font.getStyle()).append(";font-family:").append(this.font.getFamily()).append(";fill:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";fill-opacity:").append(this.alpha).append(";\"\n");
        sb_body.append(indent).append(">\n");
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_label>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        if (hs.contains("t2_label")) {
            return;
        }
        sb_header.append(indent).append("<!ELEMENT t2_label (").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_label", sb_header, hs, indent);
    }

    @Override
    public void adjustProperties() {
        GenericDialog gd = this.makeAdjustPropertiesDialog();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        String[] sizes = new String[]{"8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "60", "72"};
        String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold+Italic"};
        int i = 0;
        String family = this.font.getFamily();
        for (i = fonts.length - 1; i > -1 && !family.equals(fonts[i]); --i) {
        }
        if (-1 == i) {
            i = 0;
        }
        gd.addChoice("Font Family: ", fonts, fonts[i]);
        int size = this.font.getSize();
        for (i = sizes.length - 1; i > -1 && Integer.parseInt(sizes[i]) != size; --i) {
        }
        if (-1 == i) {
            i = 0;
        }
        gd.addChoice("Font Size: ", sizes, sizes[i]);
        gd.addNumericField("or enter size: ", (double)size, 0);
        i = 0;
        switch (this.font.getStyle()) {
            case 0: {
                i = 0;
                break;
            }
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
                break;
            }
            case 3: {
                i = 3;
            }
        }
        gd.addChoice("Font style: ", styles, styles[i]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.processAdjustPropertiesDialog(gd);
        String new_font = gd.getNextChoice();
        int new_size = Integer.parseInt(gd.getNextChoice());
        int new_size_2 = (int)gd.getNextNumber();
        if (new_size_2 != size) {
            new_size = new_size_2;
        }
        int new_style = gd.getNextChoiceIndex();
        switch (new_style) {
            case 0: {
                new_style = 0;
                break;
            }
            case 1: {
                new_style = 1;
                break;
            }
            case 2: {
                new_style = 2;
                break;
            }
            case 3: {
                new_style = 3;
            }
        }
        this.font = new Font(new_font, new_style, new_size);
        this.updateInDatabase("font");
        this.setText(this.title, true);
    }

    @Override
    public DLabel clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        DLabel copy = new DLabel(pr, nid, this.title, this.width, this.height, this.type, this.font.getName(), this.font.getStyle(), this.font.getSize(), this.locked, (AffineTransform)this.at.clone());
        copy.alpha = this.alpha;
        copy.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        copy.visible = this.visible;
        copy.addToDatabase();
        return copy;
    }

    @Override
    Class<?> getInternalDataPackageClass() {
        return DPDLabel.class;
    }

    @Override
    Object getDataPackage() {
        return new DPDLabel(this);
    }

    @Override
    public synchronized boolean apply(Layer la, Area roi, CoordinateTransform ict) throws Exception {
        double[] fp = new double[2];
        this.at.transform(fp, 0, fp, 0, 1);
        if (roi.contains(fp[0], fp[1])) {
            ict.applyInPlace(fp);
            this.at.createInverse().transform(fp, 0, fp, 0, 1);
            this.at.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, fp[0], fp[1]));
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(VectorDataTransform vdt) throws Exception {
        double[] fp = new double[2];
        this.at.transform(fp, 0, fp, 0, 1);
        for (VectorDataTransform.ROITransform rt : vdt.transforms) {
            if (!rt.roi.contains(fp[0], fp[1])) continue;
            rt.ct.applyInPlace(fp);
            this.at.createInverse().transform(fp, 0, fp, 0, 1);
            this.at.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, fp[0], fp[1]));
            return true;
        }
        return false;
    }

    private static final class DPDLabel
    extends Displayable.DataPackage {
        final Font font;

        DPDLabel(DLabel label) {
            super(label);
            this.font = new Font(label.font.getFamily(), label.font.getStyle(), label.font.getSize());
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            ((DLabel)d).font = new Font(this.font.getFamily(), this.font.getStyle(), this.font.getSize());
            return true;
        }
    }

    private class ToFront
    extends Thread {
        private final JFrame frame;

        ToFront(JFrame frame) {
            this.frame = frame;
            this.start();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.frame.toFront();
        }
    }

    private class Editor
    extends JFrame
    implements WindowListener {
        private static final long serialVersionUID = 1L;
        private final DLabel label;
        private final JTextArea jta;

        Editor(DLabel l) {
            super(DLabel.this.getShortTitle());
            this.label = l;
            this.jta = new JTextArea(this.label.title.equals("  ") ? "" : this.label.title, 5, 20);
            this.jta.setLineWrap(true);
            this.jta.setWrapStyleWord(true);
            JScrollPane jsp = new JScrollPane(this.jta);
            this.jta.setPreferredSize(new Dimension(200, 200));
            this.getContentPane().add(jsp);
            this.pack();
            this.setVisible(true);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle box = this.getBounds();
            this.setLocation((screen.width - box.width) / 2, (screen.height - box.height) / 2);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this);
            new ToFront(this);
        }

        @Override
        public void windowClosing(WindowEvent we) {
            String text = this.jta.getText().trim();
            if (null != text && text.length() > 0) {
                this.label.setTitle(text);
            } else {
                this.label.remove(false);
            }
            this.dispose();
            Display.repaint(DLabel.this.layer, (Displayable)this.label, 1);
            DLabel.this.editor = null;
        }

        @Override
        public void windowClosed(WindowEvent we) {
        }

        @Override
        public void windowOpened(WindowEvent we) {
        }

        @Override
        public void windowActivated(WindowEvent we) {
        }

        @Override
        public void windowDeactivated(WindowEvent we) {
        }

        @Override
        public void windowIconified(WindowEvent we) {
        }

        @Override
        public void windowDeiconified(WindowEvent we) {
        }
    }
}

