/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;

public class ImageFileHeader {
    public final int width;
    public final int height;
    public final int type;
    public final IFormatReader fr = new ChannelSeparator();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageFileHeader(String filepath) throws Exception {
        this.fr.setGroupFiles(false);
        try {
            this.fr.setId(filepath);
            this.width = this.fr.getSizeX();
            this.height = this.fr.getSizeY();
            if (this.fr.isRGB()) {
                this.type = 4;
                return;
            }
            switch (this.fr.getPixelType()) {
                case 0: 
                case 1: {
                    if (this.fr.isIndexed() || this.fr.isFalseColor()) {
                        this.type = 3;
                        return;
                    } else {
                        this.type = 0;
                        return;
                    }
                }
                case 2: 
                case 3: {
                    this.type = 1;
                    return;
                }
                case 6: {
                    this.type = 2;
                    return;
                }
                default: {
                    this.type = this.fr.getPixelType();
                    return;
                }
            }
        }
        finally {
            this.fr.close();
        }
    }

    public boolean isSupportedType() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }
}

