/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.persistence.FSLoader;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class DTDParser {
    private DTDParser() {
    }

    public static TemplateThing[] extractTemplate(String path) throws Exception {
        if (path.matches(".*(\\.xml|\\.xml\\.gz)")) {
            return DTDParser.parseXMLFile(path);
        }
        if (path.length() - 4 == path.lastIndexOf(".dtd")) {
            return DTDParser.parseDTDFile(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateThing[] parseDTDFile(String dtd_path) throws Exception {
        BufferedReader dis = null;
        StringBuilder data = new StringBuilder();
        try {
            String tmp;
            InputStream i_stream;
            if (FSLoader.isURL(dtd_path)) {
                i_stream = new URL(dtd_path).openStream();
            } else {
                File f = new File(dtd_path);
                if (!f.exists()) {
                    TemplateThing[] templateThingArray = null;
                    return templateThingArray;
                }
                i_stream = new FileInputStream(dtd_path);
            }
            dis = new BufferedReader(new InputStreamReader(i_stream));
            while (null != (tmp = dis.readLine())) {
                data.append(tmp);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return DTDParser.parseDTD(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateThing[] parseXMLFile(String xml_path) throws Exception {
        BufferedReader dis = null;
        StringBuilder data = new StringBuilder();
        try {
            String tmp;
            InputStream i_stream;
            if (FSLoader.isURL(xml_path)) {
                i_stream = new URL(xml_path).openStream();
            } else {
                File f = new File(xml_path);
                if (!f.exists()) {
                    TemplateThing[] templateThingArray = null;
                    return templateThingArray;
                }
                i_stream = new FileInputStream(xml_path);
            }
            if (xml_path.endsWith(".xml.gz")) {
                i_stream = new GZIPInputStream(i_stream);
            }
            dis = new BufferedReader(new InputStreamReader(i_stream));
            while (null != (tmp = dis.readLine())) {
                int i_doc = tmp.indexOf("<!DOCTYPE ");
                if (-1 == i_doc) continue;
                int i_end = -1;
                while (null != tmp && -1 == (i_end = tmp.indexOf(91))) {
                    tmp = dis.readLine();
                }
                if (-1 == i_end) {
                } else {
                    String st = tmp.substring(i_end + 1).trim();
                    if (st.length() > 0) {
                        data.append(st);
                    }
                    while (null != (tmp = dis.readLine()) && -1 == (i_end = tmp.indexOf(93))) {
                        data.append(tmp);
                    }
                    st = tmp.substring(0, i_end).trim();
                    if (st.length() > 0) {
                        data.append(st);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        if (0 == data.length()) {
            return null;
        }
        return DTDParser.parseDTD(data);
    }

    private static boolean isAllowed(String type) {
        return 0 != type.indexOf("t2_") && !type.equals("trakem2") && !type.equals("project") && 0 != type.indexOf("ict_transform");
    }

    public static TemplateThing[] parseDTD(StringBuilder data) throws Exception {
        HashMap<String, Type> ht_types = new HashMap<String, Type>();
        ArrayList<Type> types = new ArrayList<Type>();
        HashMap ht_attributes = new HashMap();
        String text = data.toString();
        int i_first = text.indexOf(60);
        int i_last = text.indexOf(62);
        String root_type_name = null;
        while (-1 != i_first && -1 != i_last) {
            if (i_last < i_first) {
                Utils.showMessage("Unbalanced '<' and '>' in the DTD document.");
                return null;
            }
            String chunk = text.substring(i_first + 1, i_last);
            int i_space = chunk.indexOf(32);
            if (chunk.startsWith("!ELEMENT")) {
                Type type = new Type(chunk.substring(i_space + 1));
                if (DTDParser.isAllowed(type.name)) {
                    ht_types.put(type.name, type);
                    types.add(type);
                } else if (type.name.equals("project")) {
                    if (null != root_type_name) {
                        throw new Exception("ERROR in XML file: more than one project template element defined:\n   At least: " + root_type_name + " and " + type.name);
                    }
                    int openp = chunk.indexOf(40);
                    if (-1 == openp) {
                        throw new Exception("ERROR in XML file: project template doesn't have a child element!");
                    }
                    int closep = chunk.indexOf(41, openp + 1);
                    root_type_name = chunk.substring(openp + 1, closep).trim();
                    if (-1 != root_type_name.indexOf(44)) {
                        throw new Exception("ERROR in XML file: project template has more than one child element!");
                    }
                }
            } else if (chunk.startsWith("!ATTLIST")) {
                Attribute attr = new Attribute(chunk.substring(i_space + 1));
                if (DTDParser.isAllowed(attr.type)) {
                    HashMap<String, Attribute> oht = (HashMap<String, Attribute>)ht_attributes.get(attr.type);
                    if (null == oht) {
                        oht = new HashMap<String, Attribute>();
                        ht_attributes.put(attr.type, oht);
                    }
                    if (oht.containsKey(attr.name)) {
                        Utils.log("Parsing DTD: already have attribute " + attr.name + " for type " + attr.type);
                    } else {
                        oht.put(attr.name, attr);
                    }
                }
            }
            i_first = text.indexOf(60, i_last + 1);
            i_last = text.indexOf(62, i_last + 1);
        }
        if (null == root_type_name) {
            HashMap<String, TypeNode> nodes = new HashMap<String, TypeNode>();
            ArrayList<TypeNode> seqnodes = new ArrayList<TypeNode>();
            for (Type type : types) {
                TypeNode tn = (TypeNode)nodes.get(type.name);
                if (null == tn) {
                    tn = new TypeNode(type.name);
                    nodes.put(type.name, tn);
                    seqnodes.add(tn);
                }
                if (!tn.children.isEmpty() || null == type.children) continue;
                for (String child : type.children) {
                    nodes.put(child, tn.addChild(child));
                }
            }
            for (TypeNode node : seqnodes) {
                if (null != node.parent) continue;
                if (null != root_type_name) {
                    Utils.log("WARNING found second DTD root: " + node.name);
                    continue;
                }
                Utils.log2("Found DTD root: " + node.name);
                root_type_name = node.name;
            }
        }
        if (null == root_type_name) {
            throw new Exception("ERROR in XML file: could not find the root element!");
        }
        Type root_type = (Type)ht_types.get(root_type_name);
        if (null == root_type) {
            throw new Exception("ERROR in XML file: could not find the root element DTDParser.Type instance!");
        }
        TemplateThing root = new TemplateThing(root_type_name);
        root_type.createChildren(root, ht_types);
        return new TemplateThing[]{root};
    }

    public static void main(String[] args) {
        try {
            if (args[0].length() - 4 == args[0].indexOf(".xml")) {
                DTDParser.parseXMLFile(args[0]);
            } else {
                DTDParser.parseDTDFile(args[0]);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    private static class TypeNode {
        private TypeNode parent;
        private Set<TypeNode> children = new HashSet<TypeNode>();
        private String name;

        TypeNode(String name) {
            this.name = name;
        }

        TypeNode addChild(String cn) {
            TypeNode child = new TypeNode(cn);
            child.parent = this;
            this.children.add(child);
            return child;
        }
    }

    private static class Type {
        String name;
        String[] children = null;
        String[] limits = null;

        Type(String chunk) {
            chunk = Utils.cleanString(chunk);
            int i = chunk.indexOf(32);
            this.name = chunk.substring(0, i).toLowerCase();
            chunk = chunk.substring(i + 1);
            i = chunk.indexOf(40);
            if (-1 == i) {
                return;
            }
            int i_end = chunk.lastIndexOf(41);
            chunk = chunk.substring(i + 1, i_end);
            chunk = chunk.replaceAll(" ", "");
            this.children = chunk.split(",");
            this.limits = new String[this.children.length];
            block3: for (i = 0; i < this.children.length; ++i) {
                char c = this.children[i].charAt(this.children[i].length() - 1);
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.limits[i] = Character.toString(c);
                        this.children[i] = this.children[i].substring(0, this.children[i].length() - 1);
                        continue block3;
                    }
                    default: {
                        this.limits[i] = null;
                    }
                }
            }
        }

        void createChildren(TemplateThing parent, Map<String, Type> ht_types) {
            if (!parent.isNested() && null != this.children) {
                for (int k = 0; k < this.children.length; ++k) {
                    Type ty = ht_types.get(this.children[k]);
                    if (null == ty) {
                        Utils.log2("DTDParser: ignoring " + this.children[k]);
                        continue;
                    }
                    String tyn = ty.name;
                    if (0 == tyn.indexOf("t2_")) {
                        tyn = tyn.substring(3);
                    }
                    TemplateThing child = new TemplateThing(tyn);
                    parent.addChild(child);
                    ty.createChildren(child, ht_types);
                }
            }
        }
    }

    private static class Attribute {
        String type;
        String name;

        Attribute(String chunk) {
            chunk = Utils.cleanString(chunk);
            String[] words = chunk.split(" ");
            this.type = words[0];
            this.name = words[1];
            if (words.length > 4) {
                Utils.log("WARNING: ignoring past the 4th word in the DTD: " + words[4] + " ... ");
            }
        }

        public boolean equals(Object ob) {
            return ob instanceof Attribute && ((Attribute)ob).name.equals(this.name);
        }
    }
}

