/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;

public class CachingThread
extends Thread {
    private static final int SIZE = 10;
    private final ArrayCache<byte[]> cacheBytes = new ArrayCache(byte[].class);
    private final ArrayCache<int[]> cacheInts = new ArrayCache(int[].class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayCache<byte[]> arrayCache = this.cacheBytes;
        synchronized (arrayCache) {
            this.cacheBytes.clear();
        }
        arrayCache = this.cacheInts;
        synchronized (arrayCache) {
            this.cacheInts.clear();
        }
    }

    public CachingThread() {
    }

    public CachingThread(Runnable r) {
        super(r);
    }

    public CachingThread(String name) {
        super(name);
    }

    public CachingThread(Runnable r, String name) {
        super(r, name);
    }

    public CachingThread(ThreadGroup tg, Runnable r) {
        super(tg, r);
    }

    public CachingThread(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public CachingThread(ThreadGroup tg, Runnable r, String name) {
        super(tg, r, name);
    }

    public CachingThread(ThreadGroup tg, Runnable r, String name, long priority) {
        super(tg, r, name, priority);
    }

    public static final byte[][] getOrCreateByteArray(int num, int length) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            byte[][] b = new byte[num][];
            for (int i = 0; i < num; ++i) {
                b[i] = (byte[])((ArrayCache)c.cacheBytes).getOrCreateArray(length);
            }
            return b;
        }
        return new byte[num][length];
    }

    public static final byte[] getOrCreateByteArray(int length) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            Object o = ((ArrayCache)c.cacheBytes).getOrCreateArray(length);
            System.out.println("instance of: " + o.getClass());
            return (byte[])o;
        }
        return new byte[length];
    }

    public static final int[] getOrCreateIntArray(int length) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            return (int[])((ArrayCache)c.cacheInts).getOrCreateArray(length);
        }
        return new int[length];
    }

    public static final void storeForReuse(byte[][] b) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            for (int i = 0; i < b.length; ++i) {
                ((ArrayCache)c.cacheBytes).storeForReuse(b[i], b[i].length);
            }
        }
    }

    public static final void storeForReuse(byte[] b) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            ((ArrayCache)c.cacheBytes).storeForReuse(b, b.length);
        }
    }

    public static final void storeForReuse(int[] b) {
        Thread t = Thread.currentThread();
        if (CachingThread.class.isAssignableFrom(t.getClass())) {
            CachingThread c = (CachingThread)t;
            ((ArrayCache)c.cacheInts).storeForReuse(b, b.length);
        }
    }

    public static final void storeArrayForReuse(Image img) {
        if (img.getClass() == BufferedImage.class) {
            DataBuffer db = ((BufferedImage)img).getData().getDataBuffer();
            if (db.getClass() == DataBufferInt.class) {
                CachingThread.storeForReuse(((DataBufferInt)db).getData());
            } else if (db.getClass() == DataBufferByte.class) {
                CachingThread.storeForReuse(((DataBufferByte)db).getData());
            }
        }
    }

    public static final void releaseAll() {
        ThreadGroup p;
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        while (null != (p = parent.getParent())) {
            parent = p;
        }
        Thread[] ts = new Thread[parent.activeCount()];
        while (parent.enumerate(ts, true) == ts.length) {
            ts = new Thread[ts.length * 2];
        }
        for (Thread t : ts) {
            if (null == t || !CachingThread.class.isAssignableFrom(t.getClass())) continue;
            ((CachingThread)t).clear();
        }
    }

    private static final class ArrayCache<A>
    extends HashMap<Integer, LinkedList<SoftReference<A>>> {
        private static final long serialVersionUID = 1L;
        private final Class<A> clazz;
        private int count = 0;

        private ArrayCache(Class<A> clazz) {
            this.clazz = clazz;
        }

        private final A getOrCreateArray(int length) {
            Object a;
            LinkedList l = (LinkedList)this.get(length);
            if (null == l) {
                return this.newArray(length);
            }
            if (l.isEmpty()) {
                this.remove(length);
                return this.newArray(length);
            }
            do {
                a = ((SoftReference)l.removeFirst()).get();
                --this.count;
            } while (null == a && !l.isEmpty());
            return (A)(null == a ? this.newArray(length) : a);
        }

        private final A newArray(int length) {
            return (A)Array.newInstance(this.clazz.getComponentType(), length);
        }

        private final void storeForReuse(A a, int length) {
            LinkedList<SoftReference<A>> l = (LinkedList<SoftReference<A>>)this.get(length);
            if (null == l) {
                l = new LinkedList<SoftReference<A>>();
                this.put(length, l);
            }
            l.add(new SoftReference<A>(a));
            ++this.count;
            if (this.count > 10) {
                this.restructure();
            }
        }

        private final synchronized void restructure() {
            LinkedList[] ls;
            this.count = 0;
            for (LinkedList l : ls = this.values().toArray(new LinkedList[this.size()])) {
                SoftReference[] s = l.toArray(new SoftReference[l.size()]);
                l.clear();
                int c = this.count;
                for (int i = 0; i < s.length && c < 10; ++i) {
                    if (null == s[i].get()) continue;
                    l.add(s[i]);
                    ++c;
                }
                this.count += l.size();
            }
        }
    }
}

