/*
 * Decompiled with CFR 0.152.
 */
package mpi.fruitfly.math.datastructures;

import mpi.fruitfly.math.datastructures.FloatArray;
import mpi.fruitfly.math.datastructures.FloatArray2D;

public class FloatArray3D
extends FloatArray {
    public final int width;
    public final int height;
    public final int depth;

    public FloatArray3D(float[] data, int width, int height, int depth) {
        super(data);
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public FloatArray3D(int width, int height, int depth) {
        super(new float[width * height * depth]);
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @Override
    public FloatArray3D clone() {
        FloatArray3D clone = new FloatArray3D(this.width, this.height, this.depth);
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        return clone;
    }

    public final int getPos(int x, int y, int z) {
        return x + this.width * (y + z * this.height);
    }

    public final float get(int x, int y, int z) {
        return this.data[this.getPos(x, y, z)];
    }

    public final float getMirror(int x, int y, int z) {
        int dir;
        int tmp;
        if (x >= this.width) {
            x = this.width - (x - this.width + 2);
        }
        if (y >= this.height) {
            y = this.height - (y - this.height + 2);
        }
        if (z >= this.depth) {
            z = this.depth - (z - this.depth + 2);
        }
        if (x < 0) {
            tmp = 0;
            dir = 1;
            while (x < 0) {
                if ((tmp += dir) == this.width - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++x;
            }
            x = tmp;
        }
        if (y < 0) {
            tmp = 0;
            dir = 1;
            while (y < 0) {
                if ((tmp += dir) == this.height - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++y;
            }
            y = tmp;
        }
        if (z < 0) {
            tmp = 0;
            dir = 1;
            while (z < 0) {
                if ((tmp += dir) == this.height - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++z;
            }
            z = tmp;
        }
        return this.data[this.getPos(x, y, z)];
    }

    public final void set(float value, int x, int y, int z) {
        this.data[this.getPos((int)x, (int)y, (int)z)] = value;
    }

    public final FloatArray2D getXPlane(int x) {
        FloatArray2D plane = new FloatArray2D(this.height, this.depth);
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.depth; ++z) {
                plane.set(this.get(x, y, z), y, z);
            }
        }
        return plane;
    }

    public final float[][] getXPlane_float(int x) {
        float[][] plane = new float[this.height][this.depth];
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.depth; ++z) {
                plane[y][z] = this.get(x, y, z);
            }
        }
        return plane;
    }

    public final FloatArray2D getYPlane(int y) {
        FloatArray2D plane = new FloatArray2D(this.width, this.depth);
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                plane.set(this.get(x, y, z), x, z);
            }
        }
        return plane;
    }

    public final float[][] getYPlane_float(int y) {
        float[][] plane = new float[this.width][this.depth];
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                plane[x][z] = this.get(x, y, z);
            }
        }
        return plane;
    }

    public final FloatArray2D getZPlane(int z) {
        FloatArray2D plane = new FloatArray2D(this.width, this.height);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                plane.set(this.get(x, y, z), x, y);
            }
        }
        return plane;
    }

    public final float[][] getZPlane_float(int z) {
        float[][] plane = new float[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                plane[x][y] = this.get(x, y, z);
            }
        }
        return plane;
    }

    public final void setXPlane(FloatArray2D plane, int x) {
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.depth; ++z) {
                this.set(plane.get(y, z), x, y, z);
            }
        }
    }

    public final void setXPlane(float[][] plane, int x) {
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.depth; ++z) {
                this.set(plane[y][z], x, y, z);
            }
        }
    }

    public final void setYPlane(FloatArray2D plane, int y) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                this.set(plane.get(x, z), x, y, z);
            }
        }
    }

    public final void setYPlane(float[][] plane, int y) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                this.set(plane[x][z], x, y, z);
            }
        }
    }

    public final void setZPlane(FloatArray2D plane, int z) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.set(plane.get(x, y), x, y, z);
            }
        }
    }

    public final void setZPlane(float[][] plane, int z) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.set(plane[x][y], x, y, z);
            }
        }
    }
}

