/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.process.ImageProcessor;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.parallel.ExecutorProvider;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.transform.ExportBestFlatImage;

public final class AlignmentUtils {
    private AlignmentUtils() {
    }

    public static final String layerName(Layer layer) {
        return new StringBuffer("layer z=").append(String.format("%.3f", layer.getZ())).append(" `").append(layer.getTitle()).append("'").toString();
    }

    public static final List<Patch> filterPatches(Layer layer, Filter<Patch> filter) {
        ArrayList<Patch> patches = layer.getAll(Patch.class);
        if (filter != null) {
            Iterator it = patches.iterator();
            while (it.hasNext()) {
                if (filter.accept((Patch)it.next())) continue;
                it.remove();
            }
        }
        return patches;
    }

    protected static final void extractAndSaveLayerFeatures(List<Layer> layerRange, Rectangle box, double scale, Filter<Patch> filter, FloatArray2DSIFT.Param siftParam, boolean clearCache, int numThreads) throws ExecutionException, InterruptedException {
        long sTime = System.currentTimeMillis();
        ExecutorService exec = ExecutorProvider.getExecutorService(1.0f / (float)numThreads);
        AtomicInteger counter = new AtomicInteger(0);
        ArrayList<Future<ArrayList<Feature>>> siftTasks = new ArrayList<Future<ArrayList<Feature>>>();
        for (Layer layer : layerRange) {
            siftTasks.add(exec.submit(new LayerFeatureCallable(layer, box, scale, filter, siftParam, clearCache)));
        }
        try {
            for (Future future : siftTasks) {
                IJ.showProgress((int)counter.getAndIncrement(), (int)(layerRange.size() - 1));
                future.get();
            }
        }
        catch (InterruptedException e) {
            Utils.log("Feature extraction interrupted.");
            IJError.print(e);
            siftTasks.clear();
            throw e;
        }
        catch (ExecutionException e) {
            Utils.log("Execution exception during feature extraction.");
            IJError.print(e);
            siftTasks.clear();
            throw e;
        }
        siftTasks.clear();
        IJ.log((String)("Extracted features in " + (System.currentTimeMillis() - sTime) + "ms"));
    }

    private static class LayerFeatureCallable
    implements Callable<ArrayList<Feature>>,
    Serializable {
        private final Layer layer;
        private final Filter<Patch> filter;
        private final boolean clearCache;
        private final Rectangle finalBox;
        final FloatArray2DSIFT.Param siftParam;
        final double scale;

        public LayerFeatureCallable(Layer layer, Rectangle finalBox, double scale, Filter<Patch> filter, FloatArray2DSIFT.Param siftParam, boolean clearCache) {
            this.layer = layer;
            this.filter = filter;
            this.clearCache = clearCache;
            this.finalBox = finalBox;
            this.siftParam = siftParam;
            this.scale = scale;
        }

        @Override
        public ArrayList<Feature> call() throws Exception {
            String layerName = AlignmentUtils.layerName(this.layer);
            List<Patch> patches = AlignmentUtils.filterPatches(this.layer, this.filter);
            ArrayList<Object> fs = null;
            if (!this.clearCache) {
                fs = Util.deserializeFeatures(this.layer.getProject(), this.siftParam, "layer", this.layer.getId());
            }
            if (null == fs) {
                this.layer.getProject().getLoader().releaseAll();
                FloatArray2DSIFT sift = new FloatArray2DSIFT(this.siftParam);
                SIFT ijSIFT = new SIFT(sift);
                fs = new ArrayList();
                ijSIFT.extractFeatures((ImageProcessor)new ExportBestFlatImage(patches, this.finalBox, 0, this.scale).makeFlatGrayImage(), fs);
                Utils.log(fs.size() + " features extracted for " + layerName);
                if (!Util.serializeFeatures(this.layer.getProject(), this.siftParam, "layer", this.layer.getId(), fs)) {
                    Utils.log("FAILED to store serialized features for " + layerName);
                }
            } else {
                Utils.log(fs.size() + " features loaded for " + layerName);
            }
            return fs;
        }
    }

    public static final class ParamPointMatch
    implements Serializable {
        private static final long serialVersionUID = 7526084042028501775L;
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public float rod = 0.92f;
        public boolean clearCache = true;
        public int maxNumThreadsSift = Runtime.getRuntime().availableProcessors();

        public boolean equals(Object o) {
            if (this.getClass().isInstance(o)) {
                ParamPointMatch oppm = (ParamPointMatch)o;
                return oppm.sift.equals(this.sift) & oppm.rod == this.rod;
            }
            return false;
        }
    }
}

