/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.imaris;

import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import bdv.img.imaris.IHDF5Access;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class HDF5AccessHack
implements IHDF5Access {
    private final IHDF5Reader hdf5Reader;
    private final long fileId;
    private final long numericConversionXferPropertyListID;
    private final long[] reorderedDimensions = new long[3];
    private final long[] reorderedMin = new long[3];
    private static final int MAX_OPEN_DATASETS = 48;
    private final OpenDataSetCache openDataSetCache;
    private static final String cellsFormatString = "DataSet/ResolutionLevel %d/TimePoint %d/Channel %d/Data";

    public HDF5AccessHack(IHDF5Reader hdf5Reader) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.hdf5Reader = hdf5Reader;
        Class<?> k = Class.forName("ch.systemsx.cisd.hdf5.HDF5Reader");
        Field f = k.getDeclaredField("baseReader");
        f.setAccessible(true);
        Object baseReader = f.get(hdf5Reader);
        Class<?> k2 = Class.forName("ch.systemsx.cisd.hdf5.HDF5BaseReader");
        Field f2 = k2.getDeclaredField("fileId");
        f2.setAccessible(true);
        this.fileId = (Long)f2.get(baseReader);
        Field f3 = k2.getDeclaredField("h5");
        f3.setAccessible(true);
        Object h5 = f3.get(baseReader);
        Class<?> k4 = Class.forName("ch.systemsx.cisd.hdf5.HDF5");
        Field f4 = k4.getDeclaredField("numericConversionXferPropertyListID");
        f4.setAccessible(true);
        this.numericConversionXferPropertyListID = (Long)f4.get(h5);
        this.openDataSetCache = new OpenDataSetCache();
    }

    @Override
    public synchronized DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        long[] realDimensions = new long[3];
        boolean exists = false;
        try {
            OpenDataSet dataset = this.openDataSetCache.getDataSet(id);
            long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
            long[] maxDimensions = new long[HDF5Constants.H5S_MAX_RANK];
            int rank = H5.H5Sget_simple_extent_dims((long)dataset.fileSpaceId, (long[])dimensions, (long[])maxDimensions);
            System.arraycopy(dimensions, 0, realDimensions, 0, rank);
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists) {
            return new DimsAndExistence(Util.reorder(realDimensions), null, true);
        }
        return new DimsAndExistence(new long[]{1L, 1L, 1L}, null, false);
    }

    @Override
    public synchronized byte[] readByteMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        byte[] dataBlock = new byte[dimensions[0] * dimensions[1] * dimensions[2]];
        this.readByteMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min, dataBlock);
        return dataBlock;
    }

    @Override
    public synchronized byte[] readByteMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min, byte[] dataBlock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        OpenDataSet dataset = this.openDataSetCache.getDataSet(new ViewLevelId(timepoint, setup, level));
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)dataset.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedMin, null, (long[])this.reorderedDimensions, null);
        H5.H5Dread((long)dataset.dataSetId, (long)HDF5Constants.H5T_NATIVE_UCHAR, (long)memorySpaceId, (long)dataset.fileSpaceId, (long)this.numericConversionXferPropertyListID, (byte[])dataBlock);
        H5.H5Sclose((long)memorySpaceId);
        return dataBlock;
    }

    @Override
    public short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        short[] dataBlock = new short[dimensions[0] * dimensions[1] * dimensions[2]];
        this.readShortMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min, dataBlock);
        return dataBlock;
    }

    @Override
    public short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min, short[] dataBlock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        OpenDataSet dataset = this.openDataSetCache.getDataSet(new ViewLevelId(timepoint, setup, level));
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)dataset.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedMin, null, (long[])this.reorderedDimensions, null);
        H5.H5Dread((long)dataset.dataSetId, (long)HDF5Constants.H5T_NATIVE_USHORT, (long)memorySpaceId, (long)dataset.fileSpaceId, (long)this.numericConversionXferPropertyListID, (Object)dataBlock);
        H5.H5Sclose((long)memorySpaceId);
        return dataBlock;
    }

    @Override
    public float[] readFloatMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        float[] dataBlock = new float[dimensions[0] * dimensions[1] * dimensions[2]];
        this.readFloatMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min, dataBlock);
        return dataBlock;
    }

    @Override
    public float[] readFloatMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min, float[] dataBlock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        OpenDataSet dataset = this.openDataSetCache.getDataSet(new ViewLevelId(timepoint, setup, level));
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)dataset.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedMin, null, (long[])this.reorderedDimensions, null);
        H5.H5Dread((long)dataset.dataSetId, (long)HDF5Constants.H5T_NATIVE_FLOAT, (long)memorySpaceId, (long)dataset.fileSpaceId, (long)this.numericConversionXferPropertyListID, (Object)dataBlock);
        H5.H5Sclose((long)memorySpaceId);
        return dataBlock;
    }

    @Override
    public synchronized String readImarisAttributeString(String objectPath, String attributeName) {
        return this.readImarisAttributeString(objectPath, attributeName, null);
    }

    @Override
    public synchronized String readImarisAttributeString(String objectPath, String attributeName, String defaultValue) {
        String attrString = defaultValue;
        long objectId = H5.H5Oopen((long)this.fileId, (String)objectPath, (long)HDF5Constants.H5P_DEFAULT);
        if (H5.H5Aexists((long)objectId, (String)attributeName)) {
            boolean isEmptyString;
            String cset;
            long attributeId = H5.H5Aopen((long)objectId, (String)attributeName, (long)HDF5Constants.H5P_DEFAULT);
            long dataTypeId = H5.H5Aget_type((long)attributeId);
            int classType = H5.H5Tget_class((long)dataTypeId);
            if (classType != HDF5Constants.H5T_STRING) {
                throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String.");
            }
            long dataTypeSize = H5.H5Tget_size((long)dataTypeId);
            if (dataTypeSize != 1L) {
                throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + ": unexpected data type size.");
            }
            boolean isVariableStr = H5.H5Tis_variable_str((long)dataTypeId);
            if (isVariableStr) {
                throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + ": expected fixed length string.");
            }
            int cValue = H5.H5Tget_cset((long)dataTypeId);
            if (cValue == HDF5Constants.H5T_CSET_ASCII) {
                cset = "US-ASCII";
            } else if (cValue == HDF5Constants.H5T_CSET_UTF8) {
                cset = "UTF-8";
            } else {
                throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + ": unexpected character set.");
            }
            long attrSpaceId = H5.H5Aget_space((long)attributeId);
            int ndims = H5.H5Sget_simple_extent_ndims((long)attrSpaceId);
            if (ndims != 1) {
                throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + ": unexpected number of dimensions.");
            }
            long[] dims = new long[ndims];
            long[] maxdims = new long[ndims];
            H5.H5Sget_simple_extent_dims((long)attrSpaceId, (long[])dims, (long[])maxdims);
            byte[] data = new byte[(int)dims[0]];
            H5.H5Aread((long)attributeId, (long)dataTypeId, (byte[])data);
            boolean bl = isEmptyString = data.length == 1 && data[0] == 0;
            if (!isEmptyString) {
                try {
                    attrString = new String(data, cset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            H5.H5Sclose((long)attrSpaceId);
            H5.H5Tclose((long)dataTypeId);
            H5.H5Aclose((long)attributeId);
        }
        H5.H5Oclose((long)objectId);
        return attrString;
    }

    protected void finalize() throws Throwable {
        try {
            for (OpenDataSet dataset : this.openDataSetCache.values()) {
                dataset.close();
            }
            this.hdf5Reader.close();
        }
        finally {
            super.finalize();
        }
    }

    static String getCellsPath(int timepoint, int setup, int level) {
        return String.format(cellsFormatString, level, timepoint, setup);
    }

    static String getCellsPath(ViewLevelId viewLevelId) {
        return HDF5AccessHack.getCellsPath(viewLevelId.getTimePointId(), viewLevelId.getViewSetupId(), viewLevelId.getLevel());
    }

    private class OpenDataSetCache
    extends LinkedHashMap<ViewLevelId, OpenDataSet> {
        private static final long serialVersionUID = 1L;

        public OpenDataSetCache() {
            super(48, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ViewLevelId, OpenDataSet> eldest) {
            if (this.size() > 48) {
                eldest.getValue().close();
                return true;
            }
            return false;
        }

        public OpenDataSet getDataSet(ViewLevelId id) {
            OpenDataSet openDataSet = (OpenDataSet)super.get(id);
            if (openDataSet == null) {
                openDataSet = new OpenDataSet(HDF5AccessHack.getCellsPath(id));
                this.put(id, openDataSet);
            }
            return openDataSet;
        }
    }

    private class OpenDataSet {
        final long dataSetId;
        final long fileSpaceId;

        public OpenDataSet(String cellsPath) {
            this.dataSetId = H5.H5Dopen((long)HDF5AccessHack.this.fileId, (String)cellsPath, (long)HDF5Constants.H5P_DEFAULT);
            this.fileSpaceId = H5.H5Dget_space((long)this.dataSetId);
        }

        public void close() {
            H5.H5Sclose((long)this.fileSpaceId);
            H5.H5Dclose((long)this.dataSetId);
        }
    }
}

