/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.remote;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.img.MipmapInfo;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.ViewLevelId;
import bdv.img.remote.AffineTransform3DJsonSerializer;
import bdv.img.remote.RemoteImageLoaderMetaData;
import bdv.img.remote.RemoteVolatileShortArrayLoader;
import bdv.util.ConstantRandomAccessible;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.view.Views;

public class RemoteImageLoader
implements ViewerImgLoader {
    protected String baseUrl;
    protected RemoteImageLoaderMetaData metadata;
    protected HashMap<ViewLevelId, int[]> cellsDimensions;
    protected VolatileGlobalCellCache cache;
    protected RemoteVolatileShortArrayLoader shortLoader;
    protected final HashMap<Integer, SetupImgLoader> setupImgLoaders;
    private boolean isOpen = false;

    public RemoteImageLoader(String baseUrl) throws IOException {
        this(baseUrl, true);
    }

    public RemoteImageLoader(String baseUrl, boolean doOpen) throws IOException {
        this.baseUrl = baseUrl;
        this.setupImgLoaders = new HashMap();
        if (doOpen) {
            this.open();
        }
    }

    @Override
    public SetupImgLoader getSetupImgLoader(int setupId) {
        this.tryopen();
        return this.setupImgLoaders.get(setupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws IOException {
        if (!this.isOpen) {
            RemoteImageLoader remoteImageLoader = this;
            synchronized (remoteImageLoader) {
                if (this.isOpen) {
                    return;
                }
                this.isOpen = true;
                URL url = new URL(this.baseUrl + "?p=init");
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(AffineTransform3D.class, (Object)new AffineTransform3DJsonSerializer());
                this.metadata = (RemoteImageLoaderMetaData)gsonBuilder.create().fromJson((Reader)new InputStreamReader(url.openStream()), RemoteImageLoaderMetaData.class);
                this.shortLoader = new RemoteVolatileShortArrayLoader(this);
                this.cache = new VolatileGlobalCellCache(this.metadata.maxNumLevels, 10);
                this.cellsDimensions = this.metadata.createCellsDimensions();
                for (int setupId : this.metadata.perSetupMipmapInfo.keySet()) {
                    this.setupImgLoaders.put(setupId, new SetupImgLoader(setupId));
                }
            }
        }
    }

    private void tryopen() {
        try {
            this.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VolatileGlobalCellCache getCacheControl() {
        this.tryopen();
        return this.cache;
    }

    public MipmapInfo getMipmapInfo(int setupId) {
        this.tryopen();
        return this.metadata.perSetupMipmapInfo.get(setupId);
    }

    public boolean existsImageData(ViewLevelId id) {
        return this.getDimsAndExistence(id).exists();
    }

    protected <T> RandomAccessibleInterval<T> getMissingDataImage(ViewLevelId id, T constant) {
        long[] d = this.getDimsAndExistence(id).getDimensions();
        return Views.interval(new ConstantRandomAccessible<T>(constant, 3), new FinalInterval(d));
    }

    public DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        this.tryopen();
        return this.metadata.dimsAndExistence.get(id);
    }

    int getCellIndex(int timepoint, int setup, int level, long[] globalPosition) {
        int[] cellDims = this.cellsDimensions.get(new ViewLevelId(timepoint, setup, level));
        int[] cellSize = this.getMipmapInfo(setup).getSubdivisions()[level];
        int[] cellPos = new int[]{(int)globalPosition[0] / cellSize[0], (int)globalPosition[1] / cellSize[1], (int)globalPosition[2] / cellSize[2]};
        return IntervalIndexer.positionToIndex(cellPos, cellDims);
    }

    protected <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(ViewLevelId id, LoadingStrategy loadingStrategy, T type) {
        this.tryopen();
        if (this.cache == null) {
            throw new RuntimeException("no connection open");
        }
        if (!this.existsImageData(id)) {
            System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found.", id.getTimePointId(), id.getViewSetupId(), id.getLevel()));
            return this.getMissingDataImage(id, type);
        }
        int timepointId = id.getTimePointId();
        int setupId = id.getViewSetupId();
        int level = id.getLevel();
        MipmapInfo mipmapInfo = this.metadata.perSetupMipmapInfo.get(setupId);
        long[] dimensions = this.metadata.dimsAndExistence.get(id).getDimensions();
        int[] cellDimensions = mipmapInfo.getSubdivisions()[level];
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        int priority = mipmapInfo.getMaxLevel() - level;
        CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
        return this.cache.createImg(grid, timepointId, setupId, level, cacheHints, this.shortLoader, type);
    }

    public class SetupImgLoader
    extends AbstractViewerSetupImgLoader<UnsignedShortType, VolatileUnsignedShortType> {
        private final int setupId;

        protected SetupImgLoader(int setupId) {
            super(new UnsignedShortType(), new VolatileUnsignedShortType());
            this.setupId = setupId;
        }

        public RandomAccessibleInterval<UnsignedShortType> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            return RemoteImageLoader.this.prepareCachedImage(id, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        @Override
        public RandomAccessibleInterval<VolatileUnsignedShortType> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            return RemoteImageLoader.this.prepareCachedImage(id, LoadingStrategy.BUDGETED, (NativeType)((Object)this.volatileType));
        }

        public double[][] getMipmapResolutions() {
            return RemoteImageLoader.this.getMipmapInfo(this.setupId).getResolutions();
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return RemoteImageLoader.this.getMipmapInfo(this.setupId).getTransforms();
        }

        public int numMipmapLevels() {
            return RemoteImageLoader.this.getMipmapInfo(this.setupId).getNumLevels();
        }
    }
}

