/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcegrouptree;

import bdv.ui.UIUtils;
import bdv.ui.sourcegrouptree.SourceGroupTreeModel;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class SourceGroupTreeCellRenderer
implements TreeCellRenderer {
    private JTree tree;
    private boolean selected;
    private boolean hasFocus;
    private Color selectionForeground;
    private Color selectionInactiveForeground;
    private Color foreground;
    private Color background;
    private Color selectionBackground;
    private Color selectionInactiveBackground;
    private boolean treeHasFocus;
    private Color selectionBorderColor;
    private Color dropCellBackground;
    private boolean rendererFillBackground;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    private GroupRenderer groupRenderer = new GroupRenderer();
    private SourceRenderer sourceRenderer = new SourceRenderer();
    private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    SourceGroupTreeCellRenderer() {
        this.updateUI();
    }

    void updateUI() {
        this.foreground = UIManager.getColor("Tree.foreground");
        this.background = UIManager.getColor("Tree.background");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionInactiveForeground = FlatUIUtils.getUIColor((String)"Tree.selectionInactiveForeground", (Color)UIUtils.mix(this.selectionForeground, this.foreground, 0.0));
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.selectionInactiveBackground = FlatUIUtils.getUIColor((String)"Tree.selectionInactiveBackground", (Color)UIUtils.mix(this.selectionBackground, this.background, 0.5));
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.dropCellBackground = FlatUIUtils.getUIColor((String)"Tree.dropCellBackground", (Color)this.selectionBackground);
        this.rendererFillBackground = UIUtils.getUIBoolean("Tree.rendererFillBackground", true);
        this.drawDashedFocusIndicator = UIUtils.getUIBoolean("Tree.drawDashedFocusIndicator", false);
        SwingUtilities.updateComponentTreeUI(this.groupRenderer);
        SwingUtilities.updateComponentTreeUI(this.sourceRenderer);
    }

    public void setTreeHasFocus(boolean hasFocus) {
        this.treeHasFocus = hasFocus;
    }

    public Color getBackgroundSelectionColor() {
        return this.treeHasFocus ? this.selectionBackground : this.selectionInactiveBackground;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.selected = selected;
        if (value instanceof SourceGroupTreeModel.GroupModel) {
            return this.groupRenderer.getTreeCellRendererComponent((SourceGroupTreeModel.GroupModel)value);
        }
        if (value instanceof SourceGroupTreeModel.SourceModel) {
            return this.sourceRenderer.getTreeCellRendererComponent((SourceGroupTreeModel.SourceModel)value);
        }
        return this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public int determineOffset(Object value) {
        if (value instanceof SourceGroupTreeModel.GroupModel) {
            return this.groupRenderer.getOffset();
        }
        if (value instanceof SourceGroupTreeModel.SourceModel) {
            return this.sourceRenderer.getOffset();
        }
        return 0;
    }

    public boolean currentHit(int x, int y) {
        return this.groupRenderer.currentHit(x, y);
    }

    public boolean activeHit(int x, int y) {
        return this.groupRenderer.activeHit(x, y);
    }

    private void paintFocus(Graphics g, int x, int y, int w, int h, Color notColor) {
        Color bsColor = this.selectionBorderColor;
        if (bsColor != null && (this.selected || !this.drawDashedFocusIndicator)) {
            g.setColor(bsColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
        if (this.drawDashedFocusIndicator && notColor != null) {
            if (this.treeBGColor != notColor) {
                this.treeBGColor = notColor;
                this.focusBGColor = new Color(~notColor.getRGB());
            }
            g.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    class SourceRenderer
    extends TreeLabel {
        private boolean isDropCell;

        SourceRenderer() {
            this.isDropCell = false;
            this.setBorder(new EmptyBorder(0, 35, 0, 0));
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(SourceGroupTreeModel.SourceModel source) {
            Color bg;
            Color fg;
            this.setText(source.getName());
            if (SourceGroupTreeCellRenderer.this.selected) {
                fg = SourceGroupTreeCellRenderer.this.treeHasFocus ? SourceGroupTreeCellRenderer.this.selectionForeground : SourceGroupTreeCellRenderer.this.selectionInactiveForeground;
                bg = SourceGroupTreeCellRenderer.this.treeHasFocus ? SourceGroupTreeCellRenderer.this.selectionBackground : SourceGroupTreeCellRenderer.this.selectionInactiveBackground;
            } else {
                fg = SourceGroupTreeCellRenderer.this.foreground;
                bg = SourceGroupTreeCellRenderer.this.background;
            }
            this.setForeground(fg);
            this.setBackground(bg);
            boolean enabled = SourceGroupTreeCellRenderer.this.tree.isEnabled();
            this.setEnabled(enabled);
            ComponentOrientation componentOrientation = SourceGroupTreeCellRenderer.this.tree.getComponentOrientation();
            this.setComponentOrientation(componentOrientation);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Color bColor = this.isDropCell ? SourceGroupTreeCellRenderer.this.dropCellBackground : (SourceGroupTreeCellRenderer.this.selected ? SourceGroupTreeCellRenderer.this.getBackgroundSelectionColor() : SourceGroupTreeCellRenderer.this.background);
            if (bColor == null) {
                bColor = this.getBackground();
            }
            if (bColor != null && SourceGroupTreeCellRenderer.this.rendererFillBackground) {
                g.setColor(bColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (SourceGroupTreeCellRenderer.this.hasFocus) {
                SourceGroupTreeCellRenderer.this.paintFocus(g, 0, 0, this.getWidth(), this.getHeight(), bColor);
            }
            super.paint(g);
        }

        public int getOffset() {
            return this.getX();
        }
    }

    class GroupRenderer
    extends JPanel {
        private final TreeLabel nameLabel;
        private final JRadioButton currentRadioButton;
        private final JCheckBox activeCheckBox;
        private boolean isDropCell = false;

        GroupRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.nameLabel = new TreeLabel();
            this.currentRadioButton = new JRadioButton();
            this.currentRadioButton.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.currentRadioButton.setOpaque(false);
            this.activeCheckBox = new JCheckBox();
            this.activeCheckBox.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.activeCheckBox.setOpaque(false);
            this.add(this.currentRadioButton);
            this.add(this.activeCheckBox);
            this.add(this.nameLabel);
            this.setOpaque(false);
            this.invalidate();
        }

        @Override
        public void setFont(Font font) {
            if (font instanceof FontUIResource) {
                font = null;
            }
            super.setFont(font);
        }

        @Override
        public Font getFont() {
            Font font = super.getFont();
            if (font == null && SourceGroupTreeCellRenderer.this.tree != null) {
                font = SourceGroupTreeCellRenderer.this.tree.getFont();
            }
            return font;
        }

        public Component getTreeCellRendererComponent(SourceGroupTreeModel.GroupModel group) {
            Color bg;
            Color fg;
            this.nameLabel.setText(group.getName());
            this.currentRadioButton.setSelected(group.isCurrent());
            this.activeCheckBox.setSelected(group.isActive());
            if (SourceGroupTreeCellRenderer.this.selected) {
                fg = SourceGroupTreeCellRenderer.this.treeHasFocus ? SourceGroupTreeCellRenderer.this.selectionForeground : SourceGroupTreeCellRenderer.this.selectionInactiveForeground;
                bg = SourceGroupTreeCellRenderer.this.treeHasFocus ? SourceGroupTreeCellRenderer.this.selectionBackground : SourceGroupTreeCellRenderer.this.selectionInactiveBackground;
            } else {
                fg = SourceGroupTreeCellRenderer.this.foreground;
                bg = SourceGroupTreeCellRenderer.this.background;
            }
            this.nameLabel.setForeground(fg);
            this.nameLabel.setBackground(bg);
            boolean enabled = SourceGroupTreeCellRenderer.this.tree.isEnabled();
            this.setEnabled(enabled);
            this.nameLabel.setEnabled(enabled);
            this.currentRadioButton.setEnabled(enabled);
            this.activeCheckBox.setEnabled(enabled);
            ComponentOrientation componentOrientation = SourceGroupTreeCellRenderer.this.tree.getComponentOrientation();
            this.setComponentOrientation(componentOrientation);
            this.nameLabel.setComponentOrientation(componentOrientation);
            this.currentRadioButton.setComponentOrientation(componentOrientation);
            this.activeCheckBox.setComponentOrientation(componentOrientation);
            this.invalidate();
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Color bColor = this.isDropCell ? SourceGroupTreeCellRenderer.this.dropCellBackground : (SourceGroupTreeCellRenderer.this.selected ? SourceGroupTreeCellRenderer.this.getBackgroundSelectionColor() : SourceGroupTreeCellRenderer.this.background);
            if (bColor == null) {
                bColor = this.getBackground();
            }
            if (bColor != null && SourceGroupTreeCellRenderer.this.rendererFillBackground) {
                g.setColor(bColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (SourceGroupTreeCellRenderer.this.hasFocus) {
                SourceGroupTreeCellRenderer.this.paintFocus(g, 0, 0, this.getWidth(), this.getHeight(), bColor);
            }
            super.paint(g);
        }

        public int getOffset() {
            return this.nameLabel.getX();
        }

        public boolean currentHit(int x, int y) {
            return this.currentRadioButton.getBounds().contains(x, y);
        }

        public boolean activeHit(int x, int y) {
            return this.activeCheckBox.getBounds().contains(x, y);
        }
    }

    class TreeLabel
    extends JLabel {
        TreeLabel() {
        }

        @Override
        public void setFont(Font font) {
            if (font instanceof FontUIResource) {
                font = null;
            }
            super.setFont(font);
        }

        @Override
        public Font getFont() {
            Font font = super.getFont();
            if (font == null && SourceGroupTreeCellRenderer.this.tree != null) {
                font = SourceGroupTreeCellRenderer.this.tree.getFont();
            }
            return font;
        }
    }
}

