/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.render.ProjectorUtils;
import bdv.viewer.render.VolatileProjector;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.operators.SetZero;
import net.imglib2.util.StopWatch;
import net.imglib2.view.Views;

public class EmptyProjector<T extends NumericType<T>>
implements VolatileProjector {
    private final RandomAccessibleInterval<T> target;
    private long lastFrameRenderNanoTime;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private boolean valid = false;

    public EmptyProjector(RandomAccessibleInterval<T> screenImage) {
        this.target = screenImage;
        this.lastFrameRenderNanoTime = -1L;
    }

    @Override
    public boolean map(boolean clearUntouchedTargetPixels) {
        if (this.canceled.get()) {
            return false;
        }
        StopWatch stopWatch = StopWatch.createAndStart();
        if (clearUntouchedTargetPixels) {
            ProjectorUtils.ArrayData array = ProjectorUtils.getARGBArrayData(this.target);
            if (array != null) {
                for (int y = 0; y < array.height(); ++y) {
                    int from = (y + array.oy()) * array.stride() + array.ox();
                    Arrays.fill(array.data(), from, from + array.width(), 0);
                }
            } else {
                Views.iterable(this.target).forEach(SetZero::setZero);
            }
        }
        this.lastFrameRenderNanoTime = stopWatch.nanoTime();
        this.valid = true;
        return true;
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

