/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SceneGraphObjectRetained;
import org.jogamp.java3d.Shape3DCompileRetained;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.TransformGroupRetained;

class CompileState {
    private final HashMap<AppearanceRetained, AppearanceRetained> knownAppearances = new HashMap();
    int numShapes = 0;
    private final HashMap<AppearanceRetained, Vector<Shape3DRetained>> shapeLists = new HashMap();
    int numMergeSets = 0;
    int numMergeShapes = 0;
    static final int BOUNDS_READ = 1;
    static final int GEOMETRY_READ = 2;
    boolean keepTG = false;
    boolean needNormalsTransform = false;
    TransformGroupRetained staticTransform = null;
    GroupRetained parentGroup = null;
    int numTransformGroups = 0;
    int numStaticTransformGroups = 0;
    int numMergedTransformGroups = 0;
    int numGroups = 0;
    int numMergedGroups = 0;
    int numShapesWSharedGeom = 0;
    int numShapesWStaticTG = 0;
    int numLinks = 0;
    int numSwitches = 0;
    int numOrderedGroups = 0;
    int numMorphs = 0;

    CompileState() {
    }

    AppearanceRetained getAppearance(AppearanceRetained app) {
        if (app.map == this && app.mapAppearance != null) {
            return app.mapAppearance;
        }
        AppearanceRetained retval = this.knownAppearances.get(app);
        if (retval == null) {
            this.knownAppearances.put(app, app);
            retval = app;
        }
        app.map = this;
        app.mapAppearance = retval;
        return retval;
    }

    void addShape(Shape3DRetained shape) {
        if (this.parentGroup != null) {
            Vector<Shape3DRetained> list = this.shapeLists.get(shape.appearance);
            if (list == null) {
                list = new Vector();
                this.shapeLists.put(shape.appearance, list);
            }
            GeometryRetained geometry = null;
            for (int i = 0; geometry == null && i < shape.geometryList.size(); ++i) {
                geometry = shape.geometryList.get(i);
            }
            if (shape.parent instanceof GroupRetained && ((GroupRetained)shape.parent).isStaticChildren() && geometry.geoType < 15) {
                list.add(shape);
            }
        }
    }

    void printStats() {
        System.err.println("numTransformGroups= " + this.numTransformGroups);
        System.err.println("numStaticTransformGroups= " + this.numStaticTransformGroups);
        System.err.println("numMergedTransformGroups= " + this.numMergedTransformGroups);
        System.err.println("numGroups= " + this.numGroups);
        System.err.println("numMergedGroups= " + this.numMergedGroups);
        System.err.println("numShapes= " + this.numShapes);
        System.err.println("numShapesWStaticTG= " + this.numShapesWStaticTG);
        System.err.println("numMergeShapes= " + this.numMergeShapes);
        System.err.println("numMergeSets= " + this.numMergeSets);
        System.err.println("numLinks= " + this.numLinks);
        System.err.println("numSwitches= " + this.numSwitches);
        System.err.println("numOrderedGroups= " + this.numOrderedGroups);
        System.err.println("numMorphs= " + this.numMorphs);
    }

    void doShapeMerge() {
        if (this.shapeLists != null) {
            Collection<Vector<Shape3DRetained>> lists = this.shapeLists.values();
            Iterator<Vector<Shape3DRetained>> listIterator = lists.iterator();
            int num = 0;
            int compileFlags = 0;
            while (listIterator.hasNext()) {
                Vector<Shape3DRetained> curList = listIterator.next();
                int numShapes = curList.size();
                Object[] shapes = new Shape3DRetained[numShapes];
                curList.copyInto(shapes);
                Shape3DRetained[] toBeMergedShapes = new Shape3DRetained[numShapes];
                if (numShapes <= 1) continue;
                for (int i = 0; i < numShapes; ++i) {
                    if (shapes[i] == null) continue;
                    GeometryRetained firstGeo = null;
                    for (num = 0; firstGeo == null && num < ((Shape3DRetained)shapes[i]).geometryList.size(); ++num) {
                        firstGeo = ((Shape3DRetained)shapes[i]).geometryList.get(num);
                    }
                    if (firstGeo == null || !(firstGeo instanceof GeometryArrayRetained)) continue;
                    int numMerge = 0;
                    Object mergeShape = shapes[i];
                    GeometryArrayRetained mergeGeo = (GeometryArrayRetained)firstGeo;
                    toBeMergedShapes[numMerge++] = mergeShape;
                    compileFlags = this.getCompileFlags((Shape3DRetained)mergeShape);
                    for (int j = i + 1; j < numShapes; ++j) {
                        if (shapes[j] == null) continue;
                        firstGeo = null;
                        for (num = 0; firstGeo == null && num < ((Shape3DRetained)shapes[j]).geometryList.size(); ++num) {
                            firstGeo = ((Shape3DRetained)shapes[j]).geometryList.get(num);
                        }
                        if (firstGeo == null || !((Shape3DRetained)shapes[j]).isEquivalent((Shape3DRetained)mergeShape) || !firstGeo.isEquivalenceClass(mergeGeo) || ((GeometryArrayRetained)firstGeo).vertexFormat != mergeGeo.vertexFormat) continue;
                        toBeMergedShapes[numMerge++] = shapes[j];
                        compileFlags |= this.getCompileFlags((Shape3DRetained)shapes[j]);
                        shapes[j] = null;
                    }
                    if (numMerge <= 1) continue;
                    GroupRetained group = (GroupRetained)toBeMergedShapes[0].parent;
                    for (int n = 0; n < numMerge; ++n) {
                        Shape3DRetained s = toBeMergedShapes[n];
                        boolean found = false;
                        int numChilds = group.numChildren();
                        for (int k = 0; k < numChilds && !found; ++k) {
                            if (group.getChild((int)k).retained != s) continue;
                            found = true;
                            group.removeChild(k);
                        }
                        if (found) continue;
                        System.err.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                    }
                    mergeShape = new Shape3DCompileRetained(toBeMergedShapes, numMerge, compileFlags);
                    ((SceneGraphObjectRetained)mergeShape).setSource(toBeMergedShapes[0].source);
                    ++this.numMergeSets;
                    this.numMergeShapes += numMerge;
                    this.parentGroup.addChild((Node)((Shape3DRetained)mergeShape).source);
                }
            }
        }
        this.shapeLists.clear();
    }

    int getCompileFlags(Shape3DRetained shape) {
        int cflag = 0;
        if (shape.allowIntersect() || shape.source.getCapability(12) || shape.boundsAutoCompute && shape.source.getCapability(3)) {
            cflag |= 2;
        }
        return cflag;
    }
}

