/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.AttributeBin;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.RenderAtomListInfo;
import org.jogamp.java3d.RenderMolecule;
import org.jogamp.java3d.ShaderBin;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TextureBin;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencySortGeom;

class TransparentRenderingInfo
implements TransparencySortGeom {
    RenderMolecule rm;
    RenderAtomListInfo rInfo;
    TransparentRenderingInfo prev;
    TransparentRenderingInfo next;
    GeometryAtom geometryAtom;
    double zVal;

    TransparentRenderingInfo() {
    }

    boolean updateState(Canvas3D cv) {
        TextureBin textureBin = this.rm.textureBin;
        AttributeBin attributeBin = textureBin.attributeBin;
        ShaderBin shaderBin = textureBin.shaderBin;
        RenderMolecule rm = textureBin.transparentRMList;
        while (rm != null && !rm.isSwitchOn()) {
            if (rm.next != null) {
                rm = rm.next;
                continue;
            }
            rm = rm.nextMap;
        }
        if (rm == null) {
            return false;
        }
        if (cv.environmentSet != attributeBin.environmentSet) {
            boolean visible;
            boolean bl = visible = attributeBin.definingRenderingAttributes == null || attributeBin.definingRenderingAttributes.visible;
            if (attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !visible || attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && visible) {
                return false;
            }
            cv.setStateToUpdate(0, attributeBin.environmentSet.lightBin);
            cv.setStateToUpdate(1, attributeBin.environmentSet);
            cv.setStateToUpdate(2, attributeBin);
            cv.setStateToUpdate(6, shaderBin);
            cv.updateEnvState();
        } else if (cv.attributeBin != attributeBin) {
            boolean visible;
            boolean bl = visible = attributeBin.definingRenderingAttributes == null || attributeBin.definingRenderingAttributes.visible;
            if (attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 0 && !visible || attributeBin.environmentSet.renderBin.view.viewCache.visibilityPolicy == 1 && visible) {
                return false;
            }
            cv.setStateToUpdate(2, attributeBin);
            cv.setStateToUpdate(6, shaderBin);
            cv.updateEnvState();
        } else if (cv.shaderBin != shaderBin) {
            cv.setStateToUpdate(6, shaderBin);
            cv.updateEnvState();
        }
        return true;
    }

    void render(Canvas3D cv) {
        if (this.updateState(cv)) {
            this.rm.textureBin.render(cv, this.rm.textureBin.transparentRMList);
        }
    }

    void sortRender(Canvas3D cv) {
        if (this.updateState(cv)) {
            this.rm.textureBin.render(cv, this);
        }
    }

    @Override
    public double getDistanceSquared() {
        return this.zVal;
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometryAtom.geometryArray[0] == null) {
            return null;
        }
        return (Geometry)this.geometryAtom.geometryArray[0].source;
    }

    @Override
    public void getLocalToVWorld(Transform3D localToVW) {
        localToVW.set(this.rm.localToVworld[0]);
    }

    @Override
    public Shape3D getShape3D() {
        return (Shape3D)this.geometryAtom.source.source;
    }
}

