/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;

public class FieldPrinter {
    private final Object obj;

    public FieldPrinter(Object o) {
        this.obj = o;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + "\n");
        sb.append(this.indent(this.dumpString(this.obj.getClass())));
        return sb.toString();
    }

    private String dumpString(Class<?> type) {
        if (type == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("--" + type + "--\n");
        sb.append("{\n");
        for (Field f : type.getDeclaredFields()) {
            Object value;
            f.setAccessible(true);
            int mods = f.getModifiers();
            if (Modifier.isFinal(mods) || Modifier.isStatic(mods)) continue;
            String name = f.getName();
            try {
                value = f.get(this.obj);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            sb.append(name + " = " + value + "\n");
        }
        sb.append("}\n");
        sb.append(this.indent(this.dumpString(type.getSuperclass())));
        return sb.toString();
    }

    private String indent(String s) {
        StringBuilder superSB = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(s, "\n");
        while (stk.hasMoreTokens()) {
            superSB.append("\t" + stk.nextToken() + "\n");
        }
        return superSB.toString();
    }
}

