/*
 * Decompiled with CFR 0.152.
 */
package io.scif.config;

import io.scif.MetadataLevel;
import io.scif.codec.CodecOptions;
import io.scif.codec.CompressionType;
import io.scif.img.ImageRegion;
import io.scif.img.ImgFactoryHeuristic;
import io.scif.img.Range;
import io.scif.img.converters.PlaneConverter;
import java.awt.image.ColorModel;
import java.util.HashMap;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class SCIFIOConfig
extends HashMap<String, Object> {
    private boolean openDataset = true;
    private boolean bufferedReading = true;
    private MetadataLevel level;
    private boolean filterMetadata;
    private boolean saveOriginalMetadata;
    private boolean writeSequential = false;
    private boolean failIfOverwriting = true;
    private ColorModel model = null;
    private int fps = 10;
    private String compression = null;
    private CodecOptions options = null;
    private boolean group = false;
    private ImgMode[] imgModes = new ImgMode[]{ImgMode.AUTO};
    private boolean openAll = false;
    private Range range = new Range("0");
    private ImageRegion region = null;
    private boolean computeMinMax = false;
    private PlaneConverter planeConverter = null;
    private ImgFactoryHeuristic imgFactoryHeuristic = null;
    private boolean writeRGB = true;
    @Parameter
    private LogService logService;

    public SCIFIOConfig() {
    }

    public SCIFIOConfig(Context context) {
        context.inject((Object)this);
    }

    public SCIFIOConfig(SCIFIOConfig config) {
        super(config);
        this.openDataset = config.openDataset;
        this.level = config.level;
        this.filterMetadata = config.filterMetadata;
        this.saveOriginalMetadata = config.saveOriginalMetadata;
        this.writeSequential = config.writeSequential;
        this.failIfOverwriting = config.failIfOverwriting;
        this.model = config.model;
        this.fps = config.fps;
        this.compression = config.compression;
        this.options = config.options;
        this.group = config.group;
        this.imgModes = config.imgModes;
        this.range = config.range;
        this.region = config.region;
        this.computeMinMax = config.computeMinMax;
        this.planeConverter = config.planeConverter;
        this.imgFactoryHeuristic = config.imgFactoryHeuristic;
        this.writeRGB = config.writeRGB;
        this.bufferedReading = config.bufferedReading;
        this.logService = config.logService;
    }

    public SCIFIOConfig enableBufferedReading(boolean enabled) {
        this.bufferedReading = enabled;
        return this;
    }

    public boolean bufferedReadingEnabled() {
        return this.bufferedReading;
    }

    public SCIFIOConfig checkerSetOpen(boolean open) {
        this.openDataset = open;
        return this;
    }

    public boolean checkerIsOpen() {
        return this.openDataset;
    }

    public MetadataLevel parserGetLevel() {
        return this.level;
    }

    public SCIFIOConfig parserSetLevel(MetadataLevel level) {
        this.level = level;
        return this;
    }

    public boolean parserIsFiltered() {
        return this.filterMetadata;
    }

    public SCIFIOConfig parserSetFiltered(boolean filterMetadata) {
        this.filterMetadata = filterMetadata;
        return this;
    }

    public boolean parserIsSaveOriginalMetadata() {
        return this.saveOriginalMetadata;
    }

    public SCIFIOConfig parserSetSaveOriginalMetadata(boolean saveOriginalMetadata) {
        this.saveOriginalMetadata = saveOriginalMetadata;
        return this;
    }

    public SCIFIOConfig writerSetFailIfOverwriting(boolean failIfOverwriting) {
        this.failIfOverwriting = failIfOverwriting;
        return this;
    }

    public boolean writerGetFailIfOverwriting() {
        return this.failIfOverwriting;
    }

    public SCIFIOConfig writerSetSequential(boolean sequential) {
        this.writeSequential = sequential;
        return this;
    }

    public boolean writerIsSequential() {
        return this.writeSequential;
    }

    public SCIFIOConfig writerSetColorModel(ColorModel cm) {
        this.model = cm;
        return this;
    }

    public ColorModel writerGetColorModel() {
        return this.model;
    }

    public SCIFIOConfig writerSetFramesPerSecond(int rate) {
        this.fps = rate;
        return this;
    }

    public int writerGetFramesPerSecond() {
        return this.fps;
    }

    public SCIFIOConfig writerSetCompression(String compress) {
        for (CompressionType ct : CompressionType.values()) {
            if (!ct.getCompression().equals(compress)) continue;
            this.compression = compress;
            return this;
        }
        String msg = "Compression option specified (" + compress + ") is invalid. Compression is still " + this.compression + ".";
        if (this.logService != null) {
            this.logService.warn((Object)msg);
        } else {
            System.err.println(msg);
        }
        return this;
    }

    public SCIFIOConfig writerSetCompression(CompressionType compressType) {
        return this.writerSetCompression(compressType.getCompression());
    }

    public String writerGetCompression() {
        return this.compression;
    }

    public SCIFIOConfig writerSetCodecOptions(CodecOptions options) {
        this.options = options;
        return this;
    }

    public CodecOptions writerGetCodecOptions() {
        return this.options;
    }

    public SCIFIOConfig groupableSetGroupFiles(boolean groupFiles) {
        this.group = groupFiles;
        return this;
    }

    public boolean groupableIsGroupFiles() {
        return this.group;
    }

    public ImgMode[] imgOpenerGetImgModes() {
        return this.imgModes;
    }

    public SCIFIOConfig imgOpenerSetImgModes(ImgMode ... imgModes) {
        this.imgModes = imgModes;
        return this;
    }

    public boolean imgOpenerIsComputeMinMax() {
        return this.computeMinMax;
    }

    public SCIFIOConfig imgOpenerSetComputeMinMax(boolean computeMinMax) {
        this.computeMinMax = computeMinMax;
        return this;
    }

    public ImageRegion imgOpenerGetRegion() {
        return this.region;
    }

    public SCIFIOConfig imgOpenerSetRegion(ImageRegion region) {
        this.region = region;
        return this;
    }

    public PlaneConverter imgOpenerGetPlaneConverter() {
        return this.planeConverter;
    }

    public SCIFIOConfig imgOpenerSetPlaneConverter(PlaneConverter planeConverter) {
        this.planeConverter = planeConverter;
        return this;
    }

    public ImgFactoryHeuristic imgOpenerGetImgFactoryHeuristic() {
        return this.imgFactoryHeuristic;
    }

    public SCIFIOConfig imgOpenerSetImgFactoryHeuristic(ImgFactoryHeuristic imgFactoryHeuristic) {
        this.imgFactoryHeuristic = imgFactoryHeuristic;
        return this;
    }

    public boolean imgOpenerIsOpenAllImages() {
        return this.openAll;
    }

    public SCIFIOConfig imgOpenerSetOpenAllImages(boolean openAll) {
        this.openAll = openAll;
        return this;
    }

    public Range imgOpenerGetRange() {
        return this.range;
    }

    public SCIFIOConfig imgOpenerSetIndex(int index) {
        return this.imgOpenerSetRange(new Range(new Long(index)));
    }

    public SCIFIOConfig imgOpenerSetRange(String range) {
        return this.imgOpenerSetRange(new Range(range));
    }

    public SCIFIOConfig imgOpenerSetRange(Range range) {
        this.range = range;
        return this;
    }

    public boolean imgSaverGetWriteRGB() {
        return this.writeRGB;
    }

    public SCIFIOConfig imgSaverSetWriteRGB(boolean rgb) {
        this.writeRGB = rgb;
        return this;
    }

    @Override
    public SCIFIOConfig clone() {
        return new SCIFIOConfig(this);
    }

    public static enum ImgMode {
        ARRAY,
        AUTO,
        CELL,
        PLANAR;

    }
}

