/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.DefaultImageMetadata;
import io.scif.Metadata;
import io.scif.filters.AbstractMetadataWrapper;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import io.scif.filters.PlaneSeparator;
import java.util.HashSet;
import java.util.Set;
import net.imagej.axis.AxisType;
import org.scijava.plugin.Plugin;

@Plugin(type=MetadataWrapper.class)
public class PlaneSeparatorMetadata
extends AbstractMetadataWrapper {
    private Set<AxisType> splitTypes = new HashSet<AxisType>();

    public int offset() {
        return this.splitTypes.size();
    }

    public void separate(AxisType ... types) {
        if (this.unwrap() != null) {
            this.matchTypes(types);
            this.populateImageMetadata();
        }
    }

    public boolean splitting(AxisType type) {
        return this.splitTypes.contains(type);
    }

    @Override
    public void wrap(Metadata meta) {
        this.splitTypes = new HashSet<AxisType>();
        for (int i = 0; i < meta.get(0).getInterleavedAxisCount(); ++i) {
            this.splitTypes.add(meta.get(0).getAxis(i).type());
        }
        super.wrap(meta);
    }

    @Override
    public Class<? extends Filter> filterType() {
        return PlaneSeparator.class;
    }

    @Override
    public void populateImageMetadata() {
        Metadata m = this.unwrap();
        this.createImageMetadata(0);
        for (int i = 0; i < m.getImageCount(); ++i) {
            DefaultImageMetadata iMeta = new DefaultImageMetadata(m.get(i));
            int offset = 0;
            for (AxisType type : this.splitTypes) {
                if (iMeta.getAxisIndex(type) < 0 || iMeta.getAxisIndex(type) >= iMeta.getPlanarAxisCount()) continue;
                iMeta.setAxis(iMeta.getPlanarAxisCount() + offset++ - 1, iMeta.getAxis(type));
                iMeta.setPlanarAxisCount(iMeta.getPlanarAxisCount() - 1);
            }
            this.add(iMeta, false);
        }
    }

    private void matchTypes(AxisType ... types) {
        this.splitTypes.clear();
        for (AxisType t : types) {
            int axisIndex = this.unwrap().get(0).getAxisIndex(t);
            if (axisIndex < 0 || axisIndex >= this.unwrap().get(0).getPlanarAxisCount()) continue;
            this.splitTypes.add(t);
        }
    }
}

