/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.Metadata;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgFactoryHeuristic;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.util.FormatTools;
import io.scif.util.MemoryTools;
import java.util.ArrayList;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import org.scijava.util.ArrayUtils;

public class DefaultImgFactoryHeuristic
implements ImgFactoryHeuristic {
    private static final double MEMORY_THRESHOLD = 0.75;

    @Override
    public <T> ImgFactory<T> createFactory(Metadata m, SCIFIOConfig.ImgMode[] imgModes, T type) throws IncompatibleTypeException {
        if (!(type instanceof NativeType)) {
            return new ListImgFactory(type);
        }
        ImgFactory<NativeType> result = this.createNativeFactory(m, imgModes, (NativeType)type);
        return result;
    }

    private <T extends NativeType<T>> ImgFactory<T> createNativeFactory(Metadata m, SCIFIOConfig.ImgMode[] imgModes, T type) throws IncompatibleTypeException {
        long maxSize = ArrayUtils.safeMultiply64((long[])new long[]{2L, 1024L, 1024L, 1024L});
        long availableMem = (long)((double)MemoryTools.totalAvailableMemory() * 0.75);
        long datasetSize = m.getDatasetSize();
        if (datasetSize <= 0L) {
            datasetSize = Long.MAX_VALUE;
        }
        long planeSize = m.get(0).getAxisLength(Axes.X) * m.get(0).getAxisLength(Axes.Y) * (long)FormatTools.getBytesPerPixel(m.get(0).getPixelType());
        boolean fitsInMemory = availableMem > datasetSize;
        ArrayList<SCIFIOConfig.ImgMode> modes = new ArrayList<SCIFIOConfig.ImgMode>(Arrays.asList(imgModes));
        modes.add(SCIFIOConfig.ImgMode.AUTO);
        for (SCIFIOConfig.ImgMode mode : modes) {
            switch (mode) {
                case AUTO: {
                    if (!fitsInMemory) {
                        return new SCIFIOCellImgFactory<T>(type);
                    }
                    if (datasetSize < maxSize) {
                        return new ArrayImgFactory(type);
                    }
                    return new PlanarImgFactory(type);
                }
                case ARRAY: {
                    if (datasetSize >= maxSize || !fitsInMemory) break;
                    return new ArrayImgFactory(type);
                }
                case PLANAR: {
                    if (planeSize >= maxSize || !fitsInMemory) break;
                    return new PlanarImgFactory(type);
                }
                case CELL: {
                    return new SCIFIOCellImgFactory<T>(type);
                }
            }
        }
        throw new IncompatibleTypeException((Object)this, "Cannot create ImgFactory of type " + type.getClass().getName());
    }
}

