/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntFunction;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.type.numeric.integer.GenericByteType;

public class CharAccessLoader
extends AbstractArrayLoader<CharAccess> {
    private final IntFunction<CharAccess> accessFactory;

    public CharAccessLoader(Reader reader, ImageRegion subRegion, IntFunction<CharAccess> accessFactory) {
        super(reader, subRegion);
        this.accessFactory = accessFactory;
    }

    @Override
    public void convertBytes(CharAccess data, byte[] bytes, int planesRead) {
        ImageMetadata iMeta = this.reader().getMetadata().get(0);
        if (this.isCompatible()) {
            int offset = planesRead * bytes.length;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(iMeta.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            int k = offset;
            while (bb.hasRemaining()) {
                data.setValue(k, bb.getChar());
                ++k;
            }
        } else {
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                char value = (char)this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public CharAccess emptyArray(int entities) {
        return this.accessFactory.apply(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 16;
    }

    @Override
    public Class<?> outputClass() {
        return GenericByteType.class;
    }
}

