/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.converters;

import io.scif.img.converters.PlaneConverter;
import io.scif.img.converters.PlaneConverterService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultPlaneConverterService
extends AbstractSingletonService<PlaneConverter>
implements PlaneConverterService {
    private ConcurrentHashMap<String, PlaneConverter> converters;
    private List<String> converterNames;

    @Override
    public Map<String, PlaneConverter> getPlaneConverters() {
        return Collections.unmodifiableMap(this.converters());
    }

    @Override
    public List<String> getPlaneConverterNames() {
        return Collections.unmodifiableList(this.converterNames());
    }

    @Override
    public PlaneConverter getPlaneConverter(String name) {
        return this.converters().get(name);
    }

    @Override
    public PlaneConverter getArrayConverter() {
        return this.getPlaneConverter("ArrayDataAccess");
    }

    @Override
    public PlaneConverter getPlanarConverter() {
        return this.getPlaneConverter("PlanarAccess");
    }

    @Override
    public PlaneConverter getDefaultConverter() {
        return this.getPlaneConverter("Default");
    }

    public Class<PlaneConverter> getPluginType() {
        return PlaneConverter.class;
    }

    private Map<? extends String, ? extends PlaneConverter> converters() {
        if (this.converters == null) {
            this.initConverters();
        }
        return this.converters;
    }

    private List<? extends String> converterNames() {
        if (this.converterNames == null) {
            this.initConverterNames();
        }
        return this.converterNames;
    }

    private synchronized void initConverters() {
        if (this.converters != null) {
            return;
        }
        ConcurrentHashMap<String, PlaneConverter> map = new ConcurrentHashMap<String, PlaneConverter>();
        for (PlaneConverter converter : this.getInstances()) {
            String name = converter.getInfo().getName();
            map.put(name, converter);
        }
        this.converters = map;
    }

    private synchronized void initConverterNames() {
        if (this.converterNames != null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (PlaneConverter converter : this.getInstances()) {
            String name = converter.getInfo().getName();
            list.add(name);
        }
        this.converterNames = list;
    }
}

