/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.services.DatasetIOService;
import java.io.IOException;
import java.net.URISyntaxException;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=IOPlugin.class, priority=-10000.0)
public class RAIIOPlugin<T extends Type<T>>
extends AbstractIOPlugin<RandomAccessibleInterval<T>> {
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private LocationService locationService;

    public Class<RandomAccessibleInterval<T>> getDataType() {
        return RandomAccessibleInterval.class;
    }

    public boolean supportsSave(String destination) {
        return this.datasetIOService.canSave(this.resolve(destination, "destination"));
    }

    public boolean supportsSave(Location destination) {
        return this.datasetIOService.canSave(destination);
    }

    public void save(RandomAccessibleInterval<T> rai, String destination) throws IOException {
        Dataset dataset = this.datasetService.create(rai);
        this.datasetIOService.save(dataset, this.resolve(destination, "destination"));
    }

    public void save(RandomAccessibleInterval<T> rai, Location destination) throws IOException {
        Dataset dataset = this.datasetService.create(rai);
        this.datasetIOService.save(dataset, destination);
    }

    private Location resolve(String uriString, String label) {
        try {
            Location location = this.locationService.resolve(uriString);
            if (location != null) {
                return location;
            }
            throw new IllegalArgumentException("Unresolvable " + label + ": " + uriString);
        }
        catch (URISyntaxException exc) {
            throw new IllegalArgumentException("Invalid " + label + ": " + uriString, exc);
        }
    }
}

