/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.Metadata;
import io.scif.Translator;
import io.scif.services.TranslatorService;
import io.scif.util.SCIFIOMetadataTools;
import java.util.HashMap;
import java.util.Map;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultTranslatorService
extends AbstractSingletonService<Translator>
implements TranslatorService {
    Map<Class<? extends Metadata>, Map<Class<? extends Metadata>, Translator>> sourceToDestMap;

    @Override
    public Translator findTranslator(Metadata source, Metadata dest, boolean exact) {
        Metadata trueSource = SCIFIOMetadataTools.unwrapMetadata(source);
        return this.findTranslator(trueSource.getClass(), dest.getClass(), exact);
    }

    @Override
    public Translator findTranslator(Class<? extends Metadata> source, Class<? extends Metadata> dest, boolean exact) {
        Translator t = this.lookup(source, dest);
        if (!exact) {
            t = this.lookup(t, Metadata.class, dest);
            t = this.lookup(t, source, Metadata.class);
            t = this.lookup(t, Metadata.class, Metadata.class);
        }
        return t;
    }

    @Override
    public boolean translate(Metadata source, Metadata dest, boolean exact) {
        Translator t = this.findTranslator(source, dest, exact);
        if (t == null) {
            return false;
        }
        t.translate(source, dest);
        return true;
    }

    public Class<Translator> getPluginType() {
        return Translator.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Translator lookup(Class<? extends Metadata> source, Class<? extends Metadata> dest) {
        Map<Class<? extends Metadata>, Translator> destMap;
        if (this.sourceToDestMap == null) {
            DefaultTranslatorService defaultTranslatorService = this;
            synchronized (defaultTranslatorService) {
                if (this.sourceToDestMap == null) {
                    this.createTranslatorMap();
                }
            }
        }
        if ((destMap = this.sourceToDestMap.get(source)) != null) {
            return destMap.get(dest);
        }
        return null;
    }

    private Translator lookup(Translator t, Class<? extends Metadata> source, Class<? extends Metadata> dest) {
        if (t == null) {
            for (int i = 0; i < this.getInstances().size() && t == null; ++i) {
                Translator translator = (Translator)this.getInstances().get(i);
                if (!translator.source().isAssignableFrom(source) || !translator.dest().isAssignableFrom(dest)) continue;
                t = translator;
            }
        }
        return t;
    }

    private void createTranslatorMap() {
        this.sourceToDestMap = new HashMap<Class<? extends Metadata>, Map<Class<? extends Metadata>, Translator>>();
        for (Translator translator : this.getInstances()) {
            this.addToMap(translator.source(), translator.dest(), this.sourceToDestMap, translator);
        }
    }

    private void addToMap(Class<? extends Metadata> key1, Class<? extends Metadata> key2, Map<Class<? extends Metadata>, Map<Class<? extends Metadata>, Translator>> map, Translator translator) {
        Map<Class<? extends Metadata>, Translator> innerMap = map.get(key1);
        if (innerMap == null) {
            innerMap = new HashMap<Class<? extends Metadata>, Translator>();
            map.put(key1, innerMap);
        }
        innerMap.put(key2, translator);
    }
}

