/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.app.View;
import org.jhotdraw.util.prefs.PreferencesUtil;

public abstract class AbstractView
extends JPanel
implements View {
    private Application application;
    @Nullable
    protected ExecutorService executor;
    private boolean hasUnsavedChanges;
    protected Preferences preferences = PreferencesUtil.userNodeForPackage(this.getClass());
    private int multipleOpenId = 1;
    private boolean isShowing;
    private String title;
    @Nullable
    private LinkedList<Disposable> disposables;
    protected URI uri;

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.disposables != null) {
            for (Disposable d : (LinkedList)this.disposables.clone()) {
                d.dispose();
            }
            this.disposables = null;
        }
        this.removeAll();
    }

    @Override
    public boolean canSaveTo(URI uri) {
        return true;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setURI(URI newValue) {
        URI oldValue = this.uri;
        this.uri = newValue;
        if (this.preferences != null && newValue != null) {
            this.preferences.put("projectFile", newValue.toString());
        }
        this.firePropertyChange("uri", oldValue, newValue);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setApplication(Application newValue) {
        Application oldValue = this.application;
        this.application = newValue;
        this.firePropertyChange("application", oldValue, newValue);
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getURI() == null && !this.hasUnsavedChanges();
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        boolean oldValue = this.hasUnsavedChanges;
        this.hasUnsavedChanges = newValue;
        this.firePropertyChange("hasUnsavedChanges", oldValue, newValue);
    }

    @Override
    public void execute(Runnable worker) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.executor.execute(worker);
    }

    @Override
    public void setMultipleOpenId(int newValue) {
        int oldValue = this.multipleOpenId;
        this.multipleOpenId = newValue;
        this.firePropertyChange("multipleOpenId", oldValue, newValue);
    }

    @Override
    public int getMultipleOpenId() {
        return this.multipleOpenId;
    }

    @Override
    public void setShowing(boolean newValue) {
        boolean oldValue = this.isShowing;
        this.isShowing = newValue;
        this.firePropertyChange("showing", oldValue, newValue);
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    public void markChangesAsSaved() {
        this.setHasUnsavedChanges(false);
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void addDisposable(Disposable disposable) {
        if (this.disposables == null) {
            this.disposables = new LinkedList();
        }
        this.disposables.add(disposable);
    }

    @Override
    public void removeDisposable(Disposable disposable) {
        if (this.disposables != null) {
            this.disposables.remove(disposable);
            if (this.disposables.isEmpty()) {
                this.disposables = null;
            }
        }
    }
}

