/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSaveUnsavedChangesAction
extends AbstractViewAction {
    @Nullable
    private Component oldFocusOwner;

    public AbstractSaveUnsavedChangesAction(Application app, @Nullable View view) {
        super(app, view);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final View v = this.getActiveView();
        if (v == null) {
            return;
        }
        if (v.isEnabled()) {
            final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            Window wAncestor = SwingUtilities.getWindowAncestor(v.getComponent());
            this.oldFocusOwner = wAncestor == null ? null : wAncestor.getFocusOwner();
            v.setEnabled(false);
            if (v.hasUnsavedChanges()) {
                URI unsavedURI = v.getURI();
                JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.saveBefore.doYouWantToSave.message", unsavedURI == null ? labels.getString("unnamedFile") : URIUtil.getName(unsavedURI)) + "</b><p>" + labels.getString("file.saveBefore.doYouWantToSave.details"), 2);
                Object[] options = new Object[]{labels.getString("file.saveBefore.saveOption.text"), labels.getString("file.saveBefore.cancelOption.text"), labels.getString("file.saveBefore.dontSaveOption.text")};
                pane.setOptions(options);
                pane.setInitialValue(options[0]);
                pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
                JSheet.showSheet(pane, v.getComponent(), new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        Object value = evt.getValue();
                        if (value == null || value.equals(labels.getString("file.saveBefore.cancelOption.text"))) {
                            v.setEnabled(true);
                        } else if (value.equals(labels.getString("file.saveBefore.dontSaveOption.text"))) {
                            AbstractSaveUnsavedChangesAction.this.doIt(v);
                            v.setEnabled(true);
                        } else if (value.equals(labels.getString("file.saveBefore.saveOption.text"))) {
                            AbstractSaveUnsavedChangesAction.this.saveView(v);
                        }
                    }
                });
            } else {
                this.doIt(v);
                v.setEnabled(true);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            }
        }
    }

    protected URIChooser getChooser(View view) {
        URIChooser chsr = (URIChooser)view.getComponent().getClientProperty("saveChooser");
        if (chsr == null) {
            chsr = this.getApplication().getModel().createSaveChooser(this.getApplication(), view);
            view.getComponent().putClientProperty("saveChooser", chsr);
        }
        return chsr;
    }

    protected void saveView(final View v) {
        if (v.getURI() == null) {
            URIChooser chooser = this.getChooser(v);
            JSheet.showSaveSheet(chooser, (Component)v.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        URI uri = evt.getChooser() instanceof JFileURIChooser && evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()).toURI() : evt.getChooser().getSelectedURI();
                        AbstractSaveUnsavedChangesAction.this.saveViewToURI(v, uri, evt.getChooser());
                    } else {
                        v.setEnabled(true);
                        if (AbstractSaveUnsavedChangesAction.this.oldFocusOwner != null) {
                            AbstractSaveUnsavedChangesAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        } else {
            this.saveViewToURI(v, v.getURI(), null);
        }
    }

    protected void saveViewToURI(final View v, final URI uri, final @Nullable URIChooser chooser) {
        v.execute(new Worker(){

            protected Object construct() throws IOException {
                v.write(uri, chooser);
                return null;
            }

            protected void done(Object value) {
                v.setURI(uri);
                v.markChangesAsSaved();
                AbstractSaveUnsavedChangesAction.this.doIt(v);
            }

            @Override
            protected void failed(Throwable value) {
                String message = value.getMessage() != null ? value.getMessage() : value.toString();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet((Component)AbstractSaveUnsavedChangesAction.this.getActiveView().getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.save.couldntSave.message", URIUtil.getName(uri)) + "</b><p>" + (message == null ? "" : message)), 0);
            }

            @Override
            protected void finished() {
                v.setEnabled(true);
                if (AbstractSaveUnsavedChangesAction.this.oldFocusOwner != null) {
                    AbstractSaveUnsavedChangesAction.this.oldFocusOwner.requestFocus();
                }
            }
        });
    }

    protected abstract void doIt(View var1);
}

