/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import org.jhotdraw.color.ColorUtil;

public abstract class AbstractColorWheelImageProducer
extends MemoryImageSource {
    protected int[] pixels;
    protected int w;
    protected int h;
    protected ColorSpace colorSpace;
    protected int radialIndex = 1;
    protected int angularIndex = 0;
    protected int verticalIndex = 2;
    protected boolean isPixelsValid = false;
    protected float verticalValue = 1.0f;
    protected boolean isLookupValid = false;

    public AbstractColorWheelImageProducer(ColorSpace sys, int w, int h) {
        super(w, h, null, 0, w);
        this.colorSpace = sys;
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.setAnimated(true);
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, w);
    }

    public void setRadialComponentIndex(int newValue) {
        this.radialIndex = newValue;
        this.isPixelsValid = false;
    }

    public void setAngularComponentIndex(int newValue) {
        this.angularIndex = newValue;
        this.isPixelsValid = false;
    }

    public void setVerticalComponentIndex(int newValue) {
        this.verticalIndex = newValue;
        this.isPixelsValid = false;
    }

    public void setVerticalValue(float newValue) {
        this.isPixelsValid = this.isPixelsValid && this.verticalValue == newValue;
        this.verticalValue = newValue;
    }

    public boolean needsGeneration() {
        return !this.isPixelsValid;
    }

    public void regenerateColorWheel() {
        if (!this.isPixelsValid) {
            this.generateColorWheel();
        }
    }

    public int getRadius() {
        return Math.min(this.w, this.h) / 2 - 2;
    }

    protected abstract void generateColorWheel();

    public Point getColorLocation(Color c) {
        float[] components = ColorUtil.fromColor(this.colorSpace, c);
        return this.getColorLocation(components);
    }

    public abstract Point getColorLocation(float[] var1);

    public abstract float[] getColorAt(int var1, int var2);
}

