/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import org.jhotdraw.color.AbstractColorWheelImageProducer;
import org.jhotdraw.color.ColorUtil;

public class PolarColorWheelImageProducer
extends AbstractColorWheelImageProducer {
    protected float[] angulars;
    protected float[] radials;
    protected int[] alphas;

    public PolarColorWheelImageProducer(ColorSpace sys, int w, int h) {
        super(sys, w, h);
    }

    protected void generateLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        float maxR = this.colorSpace.getMaxValue(this.radialIndex);
        float minR = this.colorSpace.getMinValue(this.radialIndex);
        float extentR = maxR - minR;
        float maxA = this.colorSpace.getMaxValue(this.angularIndex);
        float minA = this.colorSpace.getMinValue(this.angularIndex);
        float extentA = maxA - minA;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                int ky = cy - y;
                int index = x + y * this.w;
                float radiusRatio = (float)(Math.sqrt(squarekx + ky * ky) / (double)radius);
                if (radiusRatio <= 1.0f) {
                    this.alphas[index] = -16777216;
                    this.radials[index] = radiusRatio * extentR + minR;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, radiusRatio - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = maxR;
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0) * extentA + minA;
            }
        }
        this.isLookupValid = true;
    }

    @Override
    public void generateColorWheel() {
        if (!this.isLookupValid) {
            this.generateLookupTables();
        }
        float[] components = new float[this.colorSpace.getNumComponents()];
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            components[this.angularIndex] = this.angulars[index];
            components[this.radialIndex] = this.radials[index];
            components[this.verticalIndex] = this.verticalValue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & ColorUtil.toRGB(this.colorSpace, components);
        }
        this.newPixels();
        this.isPixelsValid = true;
    }

    @Override
    public Point getColorLocation(Color c) {
        float[] hsb = ColorUtil.fromColor(this.colorSpace, c);
        return this.getColorLocation(hsb);
    }

    @Override
    public Point getColorLocation(float[] components) {
        float radial = (components[this.radialIndex] - this.colorSpace.getMinValue(this.radialIndex)) / (this.colorSpace.getMaxValue(this.radialIndex) - this.colorSpace.getMinValue(this.radialIndex));
        float angular = (components[this.angularIndex] - this.colorSpace.getMinValue(this.angularIndex)) / (this.colorSpace.getMaxValue(this.angularIndex) - this.colorSpace.getMinValue(this.angularIndex));
        float radius = (float)Math.min(this.w, this.h) / 2.0f;
        radial = Math.max(0.0f, Math.min(1.0f, radial));
        Point p = new Point(this.w / 2 + (int)((double)(radius * radial) * Math.cos((double)angular * Math.PI * 2.0)), this.h / 2 - (int)((double)(radius * radial) * Math.sin((double)angular * Math.PI * 2.0)));
        return p;
    }

    @Override
    public float[] getColorAt(int x, int y) {
        float r = (float)Math.sqrt((x -= this.w / 2) * x + (y -= this.h / 2) * y);
        float theta = (float)Math.atan2(y, -x);
        float angular = (float)(0.5 + (double)theta / Math.PI / 2.0);
        float radial = Math.min(1.0f, r / (float)this.getRadius());
        float[] hsb = new float[3];
        hsb[this.angularIndex] = angular * (this.colorSpace.getMaxValue(this.angularIndex) - this.colorSpace.getMinValue(this.angularIndex)) + this.colorSpace.getMinValue(this.angularIndex);
        hsb[this.radialIndex] = radial * (this.colorSpace.getMaxValue(this.radialIndex) - this.colorSpace.getMinValue(this.radialIndex)) + this.colorSpace.getMinValue(this.radialIndex);
        hsb[this.verticalIndex] = this.verticalValue;
        return hsb;
    }
}

