/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;

public class DrawingColorChooserHandler
extends AbstractDrawingViewAction
implements ChangeListener {
    protected AttributeKey<Color> key;
    protected JColorChooser colorChooser;
    protected JPopupMenu popupMenu;
    protected int isUpdating;

    public DrawingColorChooserHandler(DrawingEditor editor, AttributeKey<Color> key, JColorChooser colorChooser, JPopupMenu popupMenu) {
        super(editor);
        this.key = key;
        this.colorChooser = colorChooser;
        this.popupMenu = popupMenu;
        colorChooser.getSelectionModel().addChangeListener(this);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.popupMenu.setVisible(false);
    }

    protected void applySelectedColorToFigures() {
        final Drawing drawing = this.getView().getDrawing();
        Color selectedColor = this.colorChooser.getColor();
        if (selectedColor != null && selectedColor.getAlpha() == 0) {
            selectedColor = null;
        }
        final Object restoreData = drawing.getAttributesRestoreData();
        drawing.willChange();
        drawing.set(this.key, selectedColor);
        drawing.changed();
        this.getEditor().setDefaultAttribute(this.key, selectedColor);
        final Color undoValue = selectedColor;
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return AttributeKeys.FONT_FACE.getPresentationName();
            }

            @Override
            public void undo() {
                super.undo();
                drawing.willChange();
                drawing.restoreAttributesTo(restoreData);
                drawing.changed();
            }

            @Override
            public void redo() {
                super.redo();
                drawing.willChange();
                drawing.set(DrawingColorChooserHandler.this.key, undoValue);
                drawing.changed();
            }
        };
        this.fireUndoableEditHappened(edit);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditor() != null && this.getEditor().isEnabled());
        if (this.getView() != null && this.colorChooser != null && this.popupMenu != null) {
            this.colorChooser.setEnabled(this.getView().getSelectionCount() > 0);
            this.popupMenu.setEnabled(this.getView().getSelectionCount() > 0);
            ++this.isUpdating;
            Color drawingColor = this.getView().getDrawing().get(this.key);
            this.colorChooser.setColor(drawingColor == null ? new Color(0, true) : drawingColor);
            --this.isUpdating;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isUpdating++ == 0) {
            this.applySelectedColorToFigures();
        }
        --this.isUpdating;
    }
}

