/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.io;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;

public class TextInputFormat
implements InputFormat {
    private TextHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private boolean isMultiline;

    public TextInputFormat(TextHolderFigure prototype) {
        this(prototype, "Text", "Text", "txt", false);
    }

    public TextInputFormat(TextHolderFigure prototype, String formatName, String description, String fileExtension, boolean isMultiline) {
        this.prototype = prototype;
        this.formatName = formatName;
        this.description = description;
        this.fileExtension = fileExtension;
        this.isMultiline = isMultiline;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(URI uri, Drawing drawing) throws IOException {
        this.read(new File(uri), drawing);
    }

    @Override
    public void read(URI uri, Drawing drawing, boolean replace) throws IOException {
        this.read(new File(uri), drawing, replace);
    }

    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.read(in, drawing, replace);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        if (replace) {
            drawing.removeAllChildren();
        }
        drawing.basicAddAll(0, this.createTextHolderFigures(in));
    }

    public LinkedList<Figure> createTextHolderFigures(InputStream in) throws IOException {
        LinkedList<Figure> list = new LinkedList<Figure>();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF8"));
        if (this.isMultiline) {
            TextHolderFigure figure = (TextHolderFigure)this.prototype.clone();
            StringBuilder buf = new StringBuilder();
            String line = null;
            while (line != null) {
                if (buf.length() != 0) {
                    buf.append('\n');
                }
                buf.append(line);
                line = r.readLine();
            }
            figure.setText(buf.toString());
            Dimension2DDouble s = figure.getPreferredSize();
            figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(s.width, s.height));
        } else {
            double y = 0.0;
            String line = null;
            while (line != null) {
                TextHolderFigure figure = (TextHolderFigure)this.prototype.clone();
                figure.setText(line);
                Dimension2DDouble s = figure.getPreferredSize();
                figure.setBounds(new Point2D.Double(0.0, y), new Point2D.Double(s.width, s.height));
                list.add(figure);
                y += s.height;
                line = r.readLine();
            }
        }
        if (list.size() == 0) {
            throw new IOException("No text found");
        }
        return list;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        String text = (String)t.getTransferData(DataFlavor.stringFlavor);
        LinkedList<TextHolderFigure> list = new LinkedList<TextHolderFigure>();
        if (this.isMultiline) {
            TextHolderFigure figure = (TextHolderFigure)this.prototype.clone();
            figure.setText(text);
            Dimension2DDouble s = figure.getPreferredSize();
            figure.willChange();
            figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(s.width, s.height));
            figure.changed();
            list.add(figure);
        } else {
            double y = 0.0;
            for (String line : text.split("\n")) {
                TextHolderFigure figure = (TextHolderFigure)this.prototype.clone();
                figure.setText(line);
                Dimension2DDouble s = figure.getPreferredSize();
                figure.willChange();
                figure.setBounds(new Point2D.Double(0.0, 0.0 + (y += s.height)), new Point2D.Double(s.width, s.height + y));
                figure.changed();
                list.add(figure);
            }
        }
        if (replace) {
            drawing.removeAllChildren();
        }
        drawing.addAll(list);
    }
}

