/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.EllipseFigure;

public class AnimationSample
extends JFrame {
    public AnimationSample() {
        this.initComponents();
        DefaultDrawingView view = new DefaultDrawingView();
        view.setDrawingDoubleBuffered(false);
        this.add(view);
        this.setSize(400, 400);
        DefaultDrawing d = new DefaultDrawing();
        d.set(AttributeKeys.CANVAS_FILL_COLOR, new Color(7776722));
        final EllipseFigure ellipse = new EllipseFigure(160.0, 160.0, 80.0, 80.0);
        ellipse.set(AttributeKeys.STROKE_WIDTH, 7.0);
        d.add(ellipse);
        view.setDrawing(d);
        Timer t = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double alpha = Math.PI * 2 * (double)(System.currentTimeMillis() % 1000L) / 1000.0;
                ellipse.willChange();
                ellipse.setBounds(new Rectangle2D.Double(160.0 + Math.sin(alpha) * 100.0, 160.0 + Math.cos(alpha) * 100.0, 80.0, 80.0));
                ellipse.changed();
            }
        });
        t.setRepeats(true);
        t.start();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AnimationSample().setVisible(true);
            }
        });
    }
}

