/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GraphicalCompositeFigure;
import org.jhotdraw.draw.LabelFigure;
import org.jhotdraw.draw.handle.DragHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.handle.ResizeHandleKit;
import org.jhotdraw.draw.tool.DelegationSelectionTool;

public class MovableChildFiguresSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LabeledEllipseFigure ta = new LabeledEllipseFigure();
                ta.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                LabeledEllipseFigure tb = new LabeledEllipseFigure();
                tb.setBounds(new Point2D.Double(220.0, 120.0), new Point2D.Double(310.0, 210.0));
                LabeledEllipseFigure tc = new LabeledEllipseFigure();
                tc.setBounds(new Point2D.Double(220.0, 10.0), new Point2D.Double(310.0, 100.0));
                DefaultDrawing drawing = new DefaultDrawing();
                drawing.add(ta);
                drawing.add(tb);
                drawing.add(tc);
                JFrame f = new JFrame("My Drawing");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                DefaultDrawingView view = new DefaultDrawingView();
                view.setDrawing(drawing);
                f.add(view.getComponent());
                f.add((Component)new JLabel("Press space bar to toggle handles."), "South");
                DefaultDrawingEditor editor = new DefaultDrawingEditor();
                editor.add(view);
                editor.setTool(new DelegationSelectionTool());
                f.setVisible(true);
            }
        });
    }

    private static class LabeledEllipseFigure
    extends GraphicalCompositeFigure {
        public LabeledEllipseFigure() {
            this.setPresentationFigure(new EllipseFigure());
            LabelFigure label = new LabelFigure("Label");
            label.transform(new AffineTransform(0.0f, 0.0f, 0.0f, 0.0f, 25.0f, 37.0f));
            this.add(label);
        }

        @Override
        public Collection<Handle> createHandles(int detailLevel) {
            LinkedList<Handle> handles = new LinkedList<Handle>();
            switch (detailLevel) {
                case 0: {
                    MoveHandle.addMoveHandles(this, handles);
                    for (Figure child : this.getChildren()) {
                        MoveHandle.addMoveHandles(child, handles);
                        handles.add(new DragHandle(child));
                    }
                    break;
                }
                case 1: {
                    ResizeHandleKit.addResizeHandles(this, handles);
                    break;
                }
            }
            return handles;
        }
    }
}

