/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert.figures;

import java.awt.Color;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.samples.pert.figures.TaskFigure;

public class DependencyFigure
extends LineConnectionFigure {
    public DependencyFigure() {
        this.set(AttributeKeys.STROKE_COLOR, new Color(153));
        this.set(AttributeKeys.STROKE_WIDTH, 1.0);
        this.set(AttributeKeys.END_DECORATION, new ArrowTip());
        this.setAttributeEnabled(AttributeKeys.END_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.START_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        this.setAttributeEnabled(AttributeKeys.FONT_ITALIC, false);
        this.setAttributeEnabled(AttributeKeys.FONT_UNDERLINE, false);
    }

    @Override
    public boolean canConnect(Connector start, Connector end) {
        if (start.getOwner() instanceof TaskFigure && end.getOwner() instanceof TaskFigure) {
            TaskFigure sf = (TaskFigure)start.getOwner();
            TaskFigure ef = (TaskFigure)end.getOwner();
            if (ef.getPredecessors().contains(sf)) {
                return false;
            }
            return !sf.isDependentOf(ef);
        }
        return false;
    }

    @Override
    public boolean canConnect(Connector start) {
        return start.getOwner() instanceof TaskFigure;
    }

    @Override
    protected void handleDisconnect(Connector start, Connector end) {
        TaskFigure sf = (TaskFigure)start.getOwner();
        TaskFigure ef = (TaskFigure)end.getOwner();
        sf.removeDependency(this);
        ef.removeDependency(this);
    }

    @Override
    protected void handleConnect(Connector start, Connector end) {
        TaskFigure sf = (TaskFigure)start.getOwner();
        TaskFigure ef = (TaskFigure)end.getOwner();
        sf.addDependency(this);
        ef.addDependency(this);
    }

    @Override
    public DependencyFigure clone() {
        DependencyFigure that = (DependencyFigure)super.clone();
        return that;
    }

    @Override
    public int getLayer() {
        return 1;
    }

    @Override
    public void removeNotify(Drawing d) {
        if (this.getStartFigure() != null) {
            ((TaskFigure)this.getStartFigure()).removeDependency(this);
        }
        if (this.getEndFigure() != null) {
            ((TaskFigure)this.getEndFigure()).removeDependency(this);
        }
        super.removeNotify(d);
    }
}

