/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.example;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.SerializableCallable;
import edu.utexas.clm.archipelago.data.FileChunk;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;

public class Cluster_SIFT
implements PlugIn {
    public static ArrayList<ArrayList<Feature>> clusterSIFTExtraction(Collection<String> fileNames, FloatArray2DSIFT.Param param) {
        if (Cluster.activeCluster()) {
            ExecutorService pool = Cluster.getCluster().getService(1);
            boolean executionErrorOccurred = false;
            ArrayList<ArrayList<Feature>> featuresList = new ArrayList<ArrayList<Feature>>();
            ArrayList<Future<ArrayList<Feature>>> futures = new ArrayList<Future<ArrayList<Feature>>>();
            FijiArchipelago.debug("Submitting futures");
            for (String string : fileNames) {
                futures.add(pool.submit(new SIFTCall(param.clone(), string)));
            }
            FijiArchipelago.debug("Waiting on futures");
            for (Future future : futures) {
                try {
                    featuresList.add((ArrayList<Feature>)future.get());
                }
                catch (InterruptedException ie) {
                    FijiArchipelago.err("Cluster SIFT Extraction: Interrupted while waiting for results.");
                    return featuresList;
                }
                catch (ExecutionException ee) {
                    FijiArchipelago.log("Remote exception: " + ee);
                    executionErrorOccurred = true;
                }
            }
            if (executionErrorOccurred) {
                FijiArchipelago.err("Caught at least one ExecutionError. See the log");
            }
            return featuresList;
        }
        FijiArchipelago.err("Cluster SIFT Extraction: Cluster is not active.");
        return new ArrayList<ArrayList<Feature>>();
    }

    public float runOnCluster() {
        ImagePlus ip = IJ.getImage();
        if (ip == null) {
            IJ.showMessage((String)"First, open an image");
            return 0.0f;
        }
        if (!ip.getStack().isVirtual() || !FijiArchipelago.fileIsInRoot(((VirtualStack)ip.getStack()).getFileName(1))) {
            IJ.showMessage((String)("Stack must be virtual and within the cluster file root " + FijiArchipelago.getFileRoot()));
            return 0.0f;
        }
        if (!Cluster.activeCluster() && FijiArchipelago.runClusterGUI()) {
            Cluster.getCluster().waitUntilReady();
        }
        if (Cluster.activeCluster()) {
            long sTime = System.currentTimeMillis();
            ImageStack stack = ip.getStack();
            FijiArchipelago.log("Cluster is active.");
            if (stack.isVirtual() && FijiArchipelago.fileIsInRoot(((VirtualStack)stack).getFileName(1))) {
                ArrayList<String> fileNames = new ArrayList<String>();
                VirtualStack vstack = (VirtualStack)stack;
                for (int i = 1; i <= vstack.getSize(); ++i) {
                    fileNames.add(vstack.getDirectory() + vstack.getFileName(i));
                }
                FijiArchipelago.debug("Running clusterSIFTExtraction on " + fileNames.size() + " files");
                Cluster_SIFT.clusterSIFTExtraction(fileNames, new FloatArray2DSIFT.Param());
                return System.currentTimeMillis() - sTime;
            }
            IJ.showMessage((String)"Stack wasn't virtual and in file root");
            return 0.0f;
        }
        FijiArchipelago.debug("Cluster was not ready");
        return 0.0f;
    }

    public float runLocally() {
        ImagePlus ip = IJ.getImage();
        if (ip == null) {
            IJ.showMessage((String)"First, open a virtual stack");
            return 0.0f;
        }
        if (!ip.getStack().isVirtual()) {
            IJ.showMessage((String)"Stack must be virtual");
            return 0.0f;
        }
        long sTime = System.currentTimeMillis();
        ImageStack stack = ip.getStack();
        ArrayList<1> threads = new ArrayList<1>();
        final VirtualStack vstack = (VirtualStack)stack;
        final int numCore = Runtime.getRuntime().availableProcessors();
        int p = 0;
        while (p < numCore) {
            final int n = p++;
            Thread t = new Thread(){

                @Override
                public void run() {
                    for (int i = n + 1; i <= vstack.getSize(); i += numCore) {
                        ImagePlus im = IJ.openImage((String)(vstack.getDirectory() + vstack.getFileName(i)));
                        ImageProcessor ip1 = im.getProcessor();
                        ArrayList feat = new ArrayList();
                        SIFT sift = new SIFT(new FloatArray2DSIFT(new FloatArray2DSIFT.Param()));
                        sift.extractFeatures(ip1, feat);
                        System.gc();
                    }
                }
            };
            threads.add(t);
            t.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (InterruptedException ie) {
            IJ.showMessage((String)"Interrupted while join()ing");
            return 0.0f;
        }
        return System.currentTimeMillis() - sTime;
    }

    public void run(String arg) {
        if (arg.equals("standalone")) {
            IJ.showMessage((String)("Finished after " + this.runLocally() / 1000.0f + " seconds"));
        } else if (arg.equals("cluster")) {
            IJ.showMessage((String)("Finished after " + this.runOnCluster() / 1000.0f + " seconds"));
        } else if (arg.equals("test")) {
            float clusterTime = this.runOnCluster();
            FijiArchipelago.debug("Cluster run finished");
            float aloneTime = this.runLocally();
            IJ.showMessage((String)("Cluster: " + clusterTime / 1000.0f + "s\nStand Alone: " + aloneTime / 1000.0f + "s\nSpeedup: " + aloneTime / clusterTime));
        } else {
            IJ.showMessage((String)"Must choose to run either standalone or on cluster");
        }
    }

    public static class SIFTCall
    implements SerializableCallable<ArrayList<Feature>> {
        private final FloatArray2DSIFT.Param param;
        private final FileChunk fileChunk;

        public SIFTCall(FloatArray2DSIFT.Param p, String filename) {
            this.param = p;
            this.fileChunk = new FileChunk(filename);
        }

        @Override
        public ArrayList<Feature> call() throws Exception {
            ImagePlus im = IJ.openImage((String)this.fileChunk.getData());
            FijiArchipelago.debug("attempting to open file " + this.fileChunk.getData());
            ImageProcessor ip = im.getProcessor();
            ArrayList<Feature> feat = new ArrayList<Feature>();
            SIFT sift = new SIFT(new FloatArray2DSIFT(this.param));
            sift.extractFeatures(ip, feat);
            return feat;
        }
    }
}

