/*
 * Decompiled with CFR 0.152.
 */
package org.bigdataviewer.n5;

import java.io.File;
import java.net.URI;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.bigdataviewer.n5.N5CloudImageLoader;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.jdom2.Content;
import org.jdom2.Element;

@ImgLoaderIo(format="bdv.n5.cloud", type=N5CloudImageLoader.class)
public class XmlIoN5CloudImageLoader
implements XmlIoBasicImgLoader<N5CloudImageLoader> {
    public Element toXml(N5CloudImageLoader imgLoader, File basePath) {
        return this.toXml(imgLoader, basePath.toURI());
    }

    public Element toXml(N5CloudImageLoader imgLoader, URI basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", "bdv.n5.cloud");
        elem.setAttribute("version", "0.1");
        elem.addContent((Content)XmlHelpers.pathElementURI((String)"n5", (URI)imgLoader.getN5URI(), (URI)basePath));
        return elem;
    }

    public N5CloudImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        return this.fromXml(elem, basePath.toURI(), sequenceDescription);
    }

    public N5CloudImageLoader fromXml(Element elem, URI basePathURI, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        N5Reader n5Reader;
        URI uri = XmlHelpers.loadPathURI((Element)elem, (String)"n5", (URI)basePathURI);
        try {
            N5Factory factory = new N5Factory();
            factory.s3UseCredentials();
            n5Reader = factory.openReader(StorageFormat.N5, uri);
        }
        catch (Exception e) {
            n5Reader = new N5Factory().openReader(StorageFormat.N5, uri);
        }
        return new N5CloudImageLoader(n5Reader, uri, sequenceDescription);
    }
}

