/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;

@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject
implements Constantizable {
    private final int hashCode;
    private final Object constant;
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return runtime.getNil();
        }
    };
    static final byte[] nilBytes = new byte[]{110, 105, 108};
    private static final ByteList nil = new ByteList(nilBytes, (Encoding)USASCIIEncoding.INSTANCE);

    public RubyNil(Ruby runtime) {
        super(runtime, runtime.getNilClass(), false);
        this.flags |= NIL_F | FALSE_F | FROZEN_F;
        this.hashCode = RubyInstanceConfig.CONSISTENT_HASHING_ENABLED ? 34 : System.identityHashCode(this);
        this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
    }

    public static RubyClass createNilClass(Ruby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject(), NIL_ALLOCATOR);
        runtime.setNilClass(nilClass);
        nilClass.setClassIndex(ClassIndex.NIL);
        nilClass.setReifiedClass(RubyNil.class);
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.NIL;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Void.TYPE;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    @JRubyMethod
    public static RubyFixnum to_i(ThreadContext context, IRubyObject recv2) {
        return RubyFixnum.zero(recv2.getRuntime());
    }

    @JRubyMethod
    public static RubyFloat to_f(ThreadContext context, IRubyObject recv2) {
        return RubyFloat.newFloat(context.runtime, 0.0);
    }

    @JRubyMethod
    public static RubyString to_s(ThreadContext context, IRubyObject recv2) {
        return RubyString.newEmptyString(context.runtime);
    }

    @JRubyMethod
    public static RubyArray to_a(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newEmptyArray();
    }

    @JRubyMethod
    public static RubyHash to_h(ThreadContext context, IRubyObject recv2) {
        return RubyHash.newSmallHash(context.runtime);
    }

    @JRubyMethod
    public static RubyString inspect(ThreadContext context, IRubyObject recv2) {
        return RubyNil.inspect(context.runtime);
    }

    static RubyString inspect(Ruby runtime) {
        return RubyString.newStringShared(runtime, runtime.getString(), nil);
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.runtime.newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.runtime.newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(8);
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @JRubyMethod
    public static IRubyObject to_c(ThreadContext context, IRubyObject recv2) {
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod
    public static IRubyObject to_r(ThreadContext context, IRubyObject recv2) {
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(optional=1)
    public static IRubyObject rationalize(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyNil.to_r(context, recv2);
    }

    @Override
    public Object toJava(Class target) {
        if (target.isPrimitive()) {
            if (target == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (target == Byte.TYPE) {
                return (byte)0;
            }
            if (target == Short.TYPE) {
                return (short)0;
            }
            if (target == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (target == Integer.TYPE) {
                return 0;
            }
            if (target == Long.TYPE) {
                return 0L;
            }
            if (target == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (target == Double.TYPE) {
                return 0.0;
            }
        }
        return null;
    }
}

