/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jffi.JITCompiler;
import org.jruby.ext.ffi.jffi.JITHandle;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.internal.runtime.methods.CacheableMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;

public class DefaultMethod
extends DynamicMethod
implements CacheableMethod {
    public static final boolean DEBUG = (Boolean)Options.FFI_COMPILE_DUMP.load() != false || (Boolean)Options.COMPILE_DUMP.load() != false;
    public static final boolean REIFY = (Boolean)Options.FFI_COMPILE_REIFY.load();
    protected final Signature signature;
    private final NativeInvoker defaultInvoker;
    private volatile NativeInvoker compiledInvoker;
    private JITHandle jitHandle;
    protected final Arity arity;
    protected final Function function;

    public DefaultMethod(RubyModule implementationClass, Function function, Signature signature, NativeInvoker defaultInvoker) {
        super(implementationClass, Visibility.PUBLIC, defaultInvoker.getName());
        this.arity = Arity.fixed(signature.getParameterCount());
        this.function = function;
        this.defaultInvoker = defaultInvoker;
        this.signature = signature;
    }

    @Override
    public final DynamicMethod dup() {
        return this;
    }

    @Override
    public final Arity getArity() {
        return this.arity;
    }

    @Override
    public final boolean isNative() {
        return true;
    }

    @Override
    public DynamicMethod getMethodForCaching() {
        return this.compiledInvoker != null ? this.compiledInvoker : this;
    }

    Signature getSignature() {
        return this.signature;
    }

    CallContext getCallContext() {
        return this.function.getCallContext();
    }

    long getFunctionAddress() {
        return this.function.getFunctionAddress();
    }

    protected final NativeInvoker getNativeInvoker() {
        return this.compiledInvoker != null ? this.compiledInvoker : this.tryCompilation();
    }

    private synchronized JITHandle getJITHandle() {
        if (this.jitHandle == null) {
            this.jitHandle = JITCompiler.getInstance().getHandle(this.signature, REIFY);
        }
        return this.jitHandle;
    }

    private synchronized NativeInvoker tryCompilation() {
        if (this.compiledInvoker != null) {
            return this.compiledInvoker;
        }
        NativeInvoker invoker = this.getJITHandle().compile(this.getImplementationClass(), this.function, this.signature, this.getName());
        if (invoker != null) {
            this.compiledInvoker = invoker;
            this.getImplementationClass().invalidateCacheDescendants();
            return this.compiledInvoker;
        }
        if (this.getJITHandle().compilationFailed()) {
            this.compiledInvoker = this.defaultInvoker;
            this.getImplementationClass().invalidateCacheDescendants();
        }
        return this.defaultInvoker;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.getNativeInvoker().call(context, self2, clazz, name2, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        return this.getNativeInvoker().call(context, self2, clazz, name2, args2, block);
    }

    public final NativeInvoker forceCompilation() {
        NativeInvoker invoker = null;
        while (!this.getJITHandle().compilationFailed() && (invoker = this.getJITHandle().compile(this.getImplementationClass(), this.function, this.signature, this.getName())) == null) {
        }
        return invoker;
    }
}

